/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.XPackFile;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerBase;
import com.izforge.izpack.io.FileSpanningOutputStream;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVolumePackager
extends PackagerBase {
    public static final String INSTALLER_PAK_NAME = "installer";
    private ZipOutputStream primaryJarStream;
    private IXMLElement configdata = null;

    public MultiVolumePackager() throws CompilerException {
        this("default");
    }

    public MultiVolumePackager(String compr_format) throws CompilerException {
        this(compr_format, -1);
    }

    public MultiVolumePackager(String compr_format, int compr_level) throws CompilerException {
        this.initPackCompressor(compr_format, compr_level);
    }

    @Override
    public void createInstaller(File primaryFile) throws Exception {
        this.analyzeConfigurationInformation();
        String baseName = primaryFile.getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            this.baseFile = new File(primaryFile.getParentFile(), baseName);
        } else {
            this.baseFile = primaryFile;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeInstaller();
        String packfile = this.baseFile.getParent() + File.separator + INSTALLER_PAK_NAME;
        this.writePacks(new File(packfile));
        this.primaryJarStream.close();
        this.sendStop();
    }

    private void analyzeConfigurationInformation() {
        String classname = this.getClass().getName();
        String sizeprop = classname + ".volumesize";
        String freespaceprop = classname + ".firstvolumefreespace";
        if (this.configdata == null) {
            this.variables.setProperty(sizeprop, Long.toString(650000000L));
            this.variables.setProperty(freespaceprop, Long.toString(0L));
        } else {
            String volumesize = this.configdata.getAttribute("volumesize", Long.toString(650000000L));
            String freespace = this.configdata.getAttribute("firstvolumefreespace", Long.toString(0L));
            this.variables.setProperty(sizeprop, volumesize);
            this.variables.setProperty(freespaceprop, freespace);
        }
    }

    @Override
    protected void writeSkeletonInstaller() throws IOException {
        this.sendMsg("Copying the skeleton installer", 3);
        InputStream is = MultiVolumePackager.class.getResourceAsStream("/lib/installer.jar");
        if (is == null) {
            File skeleton = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            is = new FileInputStream(skeleton);
        }
        ZipInputStream inJarStream = new ZipInputStream(is);
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("META-INF.MANIFEST.MF");
        this.copyZipWithoutExcludes(inJarStream, this.primaryJarStream, excludes);
        is = MultiVolumePackager.class.getResourceAsStream("/lib/installer.jar");
        if (is == null) {
            File skeleton = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            is = new FileInputStream(skeleton);
        }
        inJarStream = new ZipInputStream(is);
        boolean found = false;
        java.util.zip.ZipEntry ze = null;
        String modifiedmanifest = null;
        while ((ze = inJarStream.getNextEntry()) != null && !found) {
            if (!"META-INF/MANIFEST.MF".equals(ze.getName())) continue;
            long size = ze.getSize();
            byte[] buffer = new byte[4096];
            int readbytes = 0;
            int totalreadbytes = 0;
            StringBuffer manifest = new StringBuffer();
            while ((readbytes = inJarStream.read(buffer)) > 0 && (long)totalreadbytes < size) {
                totalreadbytes += readbytes;
                String tmp = new String(buffer, 0, readbytes, "utf-8");
                manifest.append(tmp);
            }
            StringReader stringreader = new StringReader(manifest.toString());
            BufferedReader reader = new BufferedReader(stringreader);
            String line = null;
            StringBuffer modified = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Main-Class:")) {
                    line = "Main-Class: com.izforge.izpack.installer.MultiVolumeInstaller";
                }
                modified.append(line);
                modified.append("\r\n");
            }
            reader.close();
            modifiedmanifest = modified.toString();
            break;
        }
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("META-INF/MANIFEST.MF"));
        this.primaryJarStream.write(modifiedmanifest.getBytes());
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerObject(String entryName, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry(entryName));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeObject(object);
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        Iterator i$ = this.installerResourceURLMap.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            String name = s = (String)i$.next();
            InputStream in = ((URL)this.installerResourceURLMap.get(name)).openStream();
            ZipEntry newEntry = new ZipEntry(name);
            long dateTime = FileUtil.getFileDateTime((URL)this.installerResourceURLMap.get(name));
            if (dateTime != -1L) {
                newEntry.setTime(dateTime);
            }
            this.primaryJarStream.putNextEntry(newEntry);
            this.copyStream(in, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            in.close();
        }
    }

    @Override
    protected void writeIncludedJars() throws IOException {
        this.sendMsg("Merging " + this.includedJarURLs.size() + " jars into installer");
        Iterator i$ = this.includedJarURLs.iterator();
        while (i$.hasNext()) {
            Object[] includedJarURL;
            Object[] current = includedJarURL = (Object[])i$.next();
            InputStream is = ((URL)current[0]).openStream();
            ZipInputStream inJarStream = new ZipInputStream(is);
            this.copyZip(inJarStream, this.primaryJarStream, (List)current[1]);
        }
    }

    private void writePacks(File primaryfile) throws Exception {
        int num = this.packsList.size();
        this.sendMsg("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        Debug.trace("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        HashMap storedFiles = new HashMap();
        String classname = this.getClass().getName();
        String volumesize = this.getVariables().getProperty(classname + ".volumesize");
        String extraspace = this.getVariables().getProperty(classname + ".firstvolumefreespace");
        long volumesizel = 650000000L;
        long extraspacel = 0L;
        if (volumesize != null) {
            volumesizel = Long.parseLong(volumesize);
        }
        if (extraspace != null) {
            extraspacel = Long.parseLong(extraspace);
        }
        Debug.trace("Volumesize: " + volumesizel);
        Debug.trace("Extra space on first volume: " + extraspacel);
        FileSpanningOutputStream fout = new FileSpanningOutputStream(primaryfile.getParent() + File.separator + primaryfile.getName() + ".pak", volumesizel);
        fout.setFirstvolumefreespacesize(extraspacel);
        int packNumber = 0;
        Iterator i$ = this.packsList.iterator();
        while (i$.hasNext()) {
            PackInfo aPacksList;
            PackInfo packInfo = aPacksList = (PackInfo)i$.next();
            Pack pack = packInfo.getPack();
            pack.nbytes = 0L;
            this.sendMsg("Writing Pack " + packNumber + ": " + pack.name, 3);
            Debug.trace("Writing Pack " + packNumber + ": " + pack.name);
            java.util.zip.ZipEntry entry = new java.util.zip.ZipEntry("packs/pack" + packNumber);
            this.primaryJarStream.putNextEntry(entry);
            ObjectOutputStream objOut = new ObjectOutputStream(this.primaryJarStream);
            objOut.writeInt(packInfo.getPackFiles().size());
            Iterator iter = packInfo.getPackFiles().iterator();
            for (Object o : packInfo.getPackFiles()) {
                boolean addFile = !pack.loose;
                PackFile packfile = (PackFile)o;
                XPackFile pf = new XPackFile(packfile);
                File file = packInfo.getFile(packfile);
                Debug.trace("Next file: " + file.getAbsolutePath());
                Object[] info = (Object[])storedFiles.get(file);
                if (info != null && !this.packJarsSeparate) {
                    Debug.trace("File already included in other pack");
                    pf.setPreviousPackFileRef((String)info[0], (Long)info[1]);
                    addFile = false;
                }
                if (addFile && !pf.isDirectory()) {
                    long pos = fout.getFilepointer();
                    pf.setArchivefileposition(pos);
                    int volumecountbeforewrite = fout.getVolumeCount();
                    FileInputStream inStream = new FileInputStream(file);
                    long bytesWritten = this.copyStream(inStream, fout);
                    fout.flush();
                    long posafterwrite = fout.getFilepointer();
                    Debug.trace("File (" + pf.sourcePath + ") " + pos + " <-> " + posafterwrite);
                    if (fout.getFilepointer() != pos + bytesWritten) {
                        Debug.trace("file: " + file.getName());
                        Debug.trace("(Filepos/BytesWritten/ExpectedNewFilePos/NewFilePointer) (" + pos + "/" + bytesWritten + "/" + (pos + bytesWritten) + "/" + fout.getFilepointer() + ")");
                        Debug.trace("Volumecount (before/after) (" + volumecountbeforewrite + "/" + fout.getVolumeCount() + ")");
                        throw new IOException("Error new filepointer is illegal");
                    }
                    if (bytesWritten != pf.length()) {
                        throw new IOException("File size mismatch when reading " + file);
                    }
                    inStream.close();
                }
                objOut.writeObject(pf);
                objOut.flush();
                pack.nbytes += pf.length();
            }
            objOut.writeInt(packInfo.getParsables().size());
            iter = packInfo.getParsables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getExecutables().size());
            iter = packInfo.getExecutables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getUpdateChecks().size());
            iter = packInfo.getUpdateChecks().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.flush();
            ++packNumber;
        }
        int volumes = fout.getVolumeCount();
        Debug.trace("Written " + volumes + " volumes");
        String volumename = primaryfile.getName() + ".pak";
        fout.flush();
        fout.close();
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("volumes.info"));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeInt(volumes);
        out.writeUTF(volumename);
        out.flush();
        this.primaryJarStream.closeEntry();
        this.primaryJarStream.putNextEntry(new java.util.zip.ZipEntry("packs.info"));
        out = new ObjectOutputStream(this.primaryJarStream);
        out.writeInt(this.packsList.size());
        Iterator i$2 = this.packsList.iterator();
        while (i$2.hasNext()) {
            PackInfo aPacksList;
            PackInfo pack = aPacksList = (PackInfo)i$2.next();
            out.writeObject(pack.getPack());
        }
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private ZipOutputStream getJarOutputStream(String name) throws IOException {
        File file = new File(this.baseFile.getParentFile(), name);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        Debug.trace("Building installer jar: " + file.getAbsolutePath());
        ZipOutputStream jar = new ZipOutputStream(new FileOutputStream(file));
        jar.setLevel(9);
        return jar;
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out, List<String> files) throws IOException {
        java.util.zip.ZipEntry zentry;
        if (!this.alreadyWrittenFiles.containsKey(out)) {
            this.alreadyWrittenFiles.put(out, new HashSet());
        }
        HashSet currentSet = (HashSet)this.alreadyWrittenFiles.get(out);
        while ((zentry = zin.getNextEntry()) != null) {
            String currentName = zentry.getName();
            String testName = currentName.replace('/', '.');
            testName = testName.replace('\\', '.');
            if (files != null) {
                Iterator<String> i = files.iterator();
                boolean founded = false;
                while (i.hasNext()) {
                    String doInclude = i.next();
                    if (!testName.matches(doInclude)) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
            }
            if (currentSet.contains(currentName)) continue;
            try {
                java.util.zip.ZipEntry newEntry = new java.util.zip.ZipEntry(currentName);
                long fileTime = zentry.getTime();
                if (fileTime != -1L) {
                    newEntry.setTime(fileTime);
                }
                out.putNextEntry(newEntry);
                this.copyStream(zin, out);
                out.closeEntry();
                zin.closeEntry();
                currentSet.add(currentName);
            }
            catch (ZipException x) {}
        }
    }

    private void copyZipWithoutExcludes(ZipInputStream zin, ZipOutputStream out, List<String> excludes) throws IOException {
        java.util.zip.ZipEntry zentry;
        if (!this.alreadyWrittenFiles.containsKey(out)) {
            this.alreadyWrittenFiles.put(out, new HashSet());
        }
        HashSet currentSet = (HashSet)this.alreadyWrittenFiles.get(out);
        while ((zentry = zin.getNextEntry()) != null) {
            String currentName = zentry.getName();
            String testName = currentName.replace('/', '.');
            testName = testName.replace('\\', '.');
            if (excludes != null) {
                Iterator<String> i = excludes.iterator();
                boolean skip = false;
                while (i.hasNext()) {
                    String doExclude = i.next();
                    if (!testName.matches(doExclude)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            if (currentSet.contains(currentName)) continue;
            try {
                java.util.zip.ZipEntry newEntry = new java.util.zip.ZipEntry(currentName);
                long fileTime = zentry.getTime();
                if (fileTime != -1L) {
                    newEntry.setTime(fileTime);
                }
                out.putNextEntry(newEntry);
                this.copyStream(zin, out);
                out.closeEntry();
                zin.closeEntry();
                currentSet.add(currentName);
            }
            catch (ZipException x) {}
        }
    }

    private long copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesInBuffer;
        byte[] buffer = new byte[5120];
        long bytesCopied = 0L;
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesInBuffer);
            bytesCopied += (long)bytesInBuffer;
        }
        return bytesCopied;
    }

    @Override
    public void addConfigurationInformation(IXMLElement data) {
        this.configdata = data;
    }

    @Override
    protected void writePacks() throws Exception {
    }
}

