/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compressor;

import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compressor.BZip2PackCompressor;
import com.izforge.izpack.compressor.DefaultPackCompressor;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.compressor.RawPackCompressor;
import java.util.HashMap;

public class PackCompressorFactory {
    private static HashMap<String, PackCompressor> typeMap = new HashMap();
    private static CompilerException ShitHappens = null;

    private PackCompressorFactory() {
    }

    public static void cachedRegister(PackCompressor pc) {
        if (!PackCompressorFactory.good()) {
            return;
        }
        try {
            PackCompressorFactory.register(pc);
        }
        catch (CompilerException e) {
            ShitHappens = e;
        }
    }

    public static void register(PackCompressor pc) throws CompilerException {
        String[] syms;
        for (String sym1 : syms = pc.getCompressionFormatSymbols()) {
            String sym = sym1.toLowerCase();
            if (typeMap.containsKey(sym)) {
                throw new CompilerException("PackCompressor for symbol " + sym + " allready registered");
            }
            typeMap.put(sym, pc);
        }
    }

    public static boolean isTypeSupported(String type) throws CompilerException {
        if (!PackCompressorFactory.good()) {
            throw ShitHappens;
        }
        type = type.toLowerCase();
        return typeMap.containsKey(type);
    }

    public static PackCompressor get(String type) throws CompilerException {
        if (!PackCompressorFactory.good()) {
            throw ShitHappens;
        }
        if (!typeMap.containsKey(type = type.toLowerCase())) {
            throw new CompilerException("No PackCompressor registered for the given symbol " + type + ".");
        }
        return typeMap.get(type);
    }

    public static CompilerException getRegisterException() {
        return ShitHappens;
    }

    public static void setRegisterException(CompilerException registerException) {
        ShitHappens = registerException;
    }

    public static boolean good() {
        return ShitHappens == null;
    }

    static {
        PackCompressorFactory.cachedRegister(new RawPackCompressor());
        PackCompressorFactory.cachedRegister(new DefaultPackCompressor());
        PackCompressorFactory.cachedRegister(new BZip2PackCompressor());
    }
}

