/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomatedInstaller
extends InstallerBase {
    private TreeMap<String, Integer> panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;

    public AutomatedInstaller(String inputFilename) throws Exception {
        File input = new File(inputFilename);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(input);
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        this.idata.locale = new Locale(GUIInstaller.LANG_CODES_MAP.get(this.idata.localeISO3));
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        this.idata.langpack = new LocaleDatabase(in);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        this.idata.setVariable("LOCALE_IDENTIFIER", this.idata.locale.toString());
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.loadConditions(this.idata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
    }

    private boolean writeUninstallData() {
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getUninstalableFilesList();
            ZipOutputStream outJar = this.idata.uninstallOutJar;
            if (outJar == null) {
                return true;
            }
            System.out.println("[ Writing the uninstaller data ... ]");
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.idata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                logWriter.write((String)iter.next());
                if (!iter.hasNext()) continue;
                logWriter.newLine();
            }
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
            }
            outJar.flush();
            outJar.close();
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstall() throws Exception {
        block10: {
            if (!this.checkInstallerRequirements(this.idata)) {
                Debug.log("not all installerconditions are fulfilled.");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            Debug.log("[ Starting automated installation ]");
            ConsolePanelAutomationHelper uihelper = new ConsolePanelAutomationHelper();
            try {
                this.result = true;
                VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
                for (Panel p : this.idata.panelsOrder) {
                    if (p.hasCondition() && !this.idata.getRules().isConditionTrue(p.getCondition(), this.idata.variables)) {
                        Debug.log("Condition for panel " + p.getPanelid() + "is not fulfilled, skipping panel!");
                        if (this.panelInstanceCount.containsKey(p.className)) {
                            this.panelInstanceCount.put(p.className, this.panelInstanceCount.get(p.className) + 1);
                            continue;
                        }
                        this.panelInstanceCount.put(p.className, 1);
                        continue;
                    }
                    if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                    PanelAutomation automationHelper = this.getPanelAutomationHelper(p);
                    if (automationHelper == null) {
                        this.executePreValidateActions(p, uihelper);
                        this.validatePanel(p);
                        this.executePostValidateActions(p, uihelper);
                        continue;
                    }
                    IXMLElement panelRoot = this.updateInstanceCount(p);
                    this.installPanel(p, automationHelper, panelRoot);
                    this.refreshDynamicVariables(substitutor, this.idata);
                }
                this.writeUninstallData();
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                    break block10;
                }
                System.out.println("[ Automated installation FAILED! ]");
            }
            catch (Exception e) {
                try {
                    this.result = false;
                    System.err.println(e.toString());
                    e.printStackTrace();
                    System.out.println("[ Automated installation FAILED! ]");
                }
                catch (Throwable throwable) {
                    Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                    throw throwable;
                }
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private void installPanel(Panel p, PanelAutomation automationHelper, IXMLElement panelRoot) throws InstallerException {
        this.executePreActivateActions(p, null);
        Debug.log("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " entered.");
        automationHelper.runAutomated(this.idata, panelRoot);
        Debug.log("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " successfully done.");
        this.executePreValidateActions(p, null);
        this.validatePanel(p);
        this.executePostValidateActions(p, null);
    }

    private IXMLElement updateInstanceCount(Panel p) {
        String panelClassName = p.className;
        Vector<IXMLElement> panelRoots = this.idata.xmlData.getChildrenNamed(panelClassName);
        int panelRootNo = 0;
        if (this.panelInstanceCount.containsKey(panelClassName)) {
            panelRootNo = this.panelInstanceCount.get(panelClassName);
        }
        IXMLElement panelRoot = panelRoots.elementAt(panelRootNo);
        this.panelInstanceCount.put(panelClassName, panelRootNo + 1);
        return panelRoot;
    }

    private PanelAutomation getPanelAutomationHelper(Panel p) {
        Class<?> automationHelperClass = null;
        PanelAutomation automationHelperInstance = null;
        String praefix = "com.izforge.izpack.panels.";
        if (p.className.compareTo(".") > -1) {
            praefix = "";
        }
        String automationHelperClassName = praefix + p.className + "AutomationHelper";
        try {
            Debug.log("AutomationHelper:" + automationHelperClassName);
            automationHelperClass = Class.forName(automationHelperClassName);
        }
        catch (ClassNotFoundException e) {
            Debug.log("ClassNotFoundException-skip :" + automationHelperClassName);
        }
        this.executePreConstructActions(p, null);
        if (automationHelperClass != null) {
            try {
                Debug.log("Instantiate :" + automationHelperClassName);
                automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
            }
            catch (IllegalAccessException e) {
                Debug.log("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
            }
            catch (InstantiationException e) {
                Debug.log("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
            }
        }
        return automationHelperInstance;
    }

    private void validatePanel(Panel p) throws InstallerException {
        DataValidator validator;
        DataValidator.Status validationResult;
        String dataValidator = p.getValidator();
        if (dataValidator != null && (validationResult = (validator = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.idata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && validator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
                return;
            }
            this.result = false;
            throw new InstallerException("Validating data for panel " + p.getPanelid() + " was not successfull");
        }
    }

    public IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser();
        IXMLElement rtn = parser.parse(in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> actions) {
        ArrayList<PanelAction> actionList = null;
        if (actions != null) {
            actionList = new ArrayList<PanelAction>();
            for (String actionClassName : actions) {
                PanelAction action = PanelActionFactory.createPanelAction(actionClassName);
                action.initialize(panel.getPanelActionConfiguration(actionClassName));
                actionList.add(action);
            }
        }
        return actionList;
    }

    private void executePreConstructActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preConstructActions = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (preConstructActions != null) {
            for (PanelAction preConstructAction : preConstructActions) {
                preConstructAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreActivateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preActivateActions = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (preActivateActions != null) {
            for (PanelAction preActivateAction : preActivateActions) {
                preActivateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preValidateActions = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (preValidateActions != null) {
            for (PanelAction preValidateAction : preValidateActions) {
                preValidateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePostValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> postValidateActions = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (postValidateActions != null) {
            for (PanelAction postValidateAction : postValidateActions) {
                postValidateAction.executeAction(this.idata, handler);
            }
        }
    }
}

