/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata = new AutomatedInstallData();
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;

    public ConsoleInstaller(String langcode) throws Exception {
        this.loadInstallData(this.installdata);
        this.installdata.localeISO3 = langcode;
        if (this.installdata.localeISO3 == null) {
            this.installdata.localeISO3 = this.getAvailableLangPacks().get(0);
        }
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        this.installdata.locale = new Locale(GUIInstaller.LANG_CODES_MAP.get(this.installdata.localeISO3));
        this.installdata.setVariable("LOCALE_IDENTIFIER", this.installdata.locale.toString());
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        this.addCustomLangpack(this.installdata);
    }

    protected void iterateAndPerformAction(String strAction) throws Exception {
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        Debug.log("[ Starting console installation ] " + strAction);
        try {
            this.result = true;
            Iterator<Panel> panelsIterator = this.installdata.panelsOrder.iterator();
            this.installdata.curPanelNumber = -1;
            VariableSubstitutor substitutor = new VariableSubstitutor(this.installdata.getVariables());
            while (panelsIterator.hasNext()) {
                Panel p = panelsIterator.next();
                ++this.installdata.curPanelNumber;
                String praefix = "com.izforge.izpack.panels.";
                if (p.className.compareTo(".") > -1) {
                    praefix = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                String panelClassName = p.className;
                String consoleHelperClassName = praefix + panelClassName + "ConsoleHelper";
                Class<?> consoleHelperClass = null;
                Debug.log("ConsoleHelper:" + consoleHelperClassName);
                try {
                    consoleHelperClass = Class.forName(consoleHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    Debug.log("ClassNotFoundException-skip :" + consoleHelperClassName);
                    continue;
                }
                this.executePreConstructActions(p);
                PanelConsole consoleHelperInstance = null;
                if (consoleHelperClass != null) {
                    try {
                        Debug.log("Instantiate :" + consoleHelperClassName);
                        this.refreshDynamicVariables(substitutor, this.installdata);
                        consoleHelperInstance = (PanelConsole)consoleHelperClass.newInstance();
                    }
                    catch (Exception e) {
                        Debug.log("ERROR: no default constructor for " + consoleHelperClassName + ", skipping...");
                        continue;
                    }
                }
                if (consoleHelperInstance == null) continue;
                try {
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " entered.");
                    boolean bActionResult = true;
                    boolean bIsConditionFulfilled = true;
                    String strCondition = p.getCondition();
                    if (strCondition != null) {
                        bIsConditionFulfilled = this.installdata.getRules().isConditionTrue(strCondition);
                    }
                    this.executePreActivateActions(p);
                    if (strAction.equals("doInstall") && bIsConditionFulfilled) {
                        boolean valid = true;
                        do {
                            bActionResult = consoleHelperInstance.runConsole(this.installdata);
                            this.executePreValidateActions(p);
                            valid = this.validatePanel(p);
                            this.executePostValidateActions(p);
                        } while (!valid);
                    } else if (strAction.equals("doGeneratePropertiesFile")) {
                        bActionResult = consoleHelperInstance.runGeneratePropertiesFile(this.installdata, this.printWriter);
                    } else if (strAction.equals("doInstallFromPropertiesFile") && bIsConditionFulfilled) {
                        bActionResult = consoleHelperInstance.runConsoleFromPropertiesFile(this.installdata, this.properties);
                    }
                    if (!bActionResult) {
                        this.result = false;
                        return;
                    }
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " successfully done.");
                }
                catch (Exception e) {
                    Debug.log("ERROR: console installation failed for panel " + panelClassName);
                    e.printStackTrace();
                    this.result = false;
                }
            }
            if (this.result) {
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception e) {
            this.result = false;
            System.err.println(e.toString());
            e.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
        }
    }

    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doGeneratePropertiesFile(String strFile) throws Exception {
        try {
            this.printWriter = new PrintWriter(strFile);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.printWriter.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doInstallFromPropertiesFile(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                in.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        in.close();
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private boolean validatePanel(Panel p) throws InstallerException {
        DataValidator validator;
        DataValidator.Status validationResult;
        String dataValidator = p.getValidator();
        if (dataValidator != null && (validationResult = (validator = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.installdata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && validator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
            } else {
                System.out.println("Validation failed, please verify your input");
                return false;
            }
        }
        return true;
    }

    public void run(int type, String path) throws Exception {
        switch (type) {
            case 1: {
                this.doGeneratePropertiesFile(path);
                break;
            }
            case 2: {
                this.doInstallFromPropertiesFile(path);
                break;
            }
            default: {
                this.doInstall();
            }
        }
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> actions) {
        ArrayList<PanelAction> actionList = null;
        if (actions != null) {
            actionList = new ArrayList<PanelAction>();
            for (String actionClassName : actions) {
                PanelAction action = PanelActionFactory.createPanelAction(actionClassName);
                action.initialize(panel.getPanelActionConfiguration(actionClassName));
                actionList.add(action);
            }
        }
        return actionList;
    }

    private void executePreConstructActions(Panel panel) {
        List<PanelAction> preConstructActions = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (preConstructActions != null) {
            for (PanelAction preConstructAction : preConstructActions) {
                preConstructAction.executeAction(this.installdata, null);
            }
        }
    }

    private void executePreActivateActions(Panel panel) {
        List<PanelAction> preActivateActions = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (preActivateActions != null) {
            for (PanelAction preActivateAction : preActivateActions) {
                preActivateAction.executeAction(this.installdata, null);
            }
        }
    }

    private void executePreValidateActions(Panel panel) {
        List<PanelAction> preValidateActions = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (preValidateActions != null) {
            for (PanelAction preValidateAction : preValidateActions) {
                preValidateAction.executeAction(this.installdata, null);
            }
        }
    }

    private void executePostValidateActions(Panel panel) {
        List<PanelAction> postValidateActions = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (postValidateActions != null) {
            for (PanelAction postValidateAction : postValidateActions) {
                postValidateAction.executeAction(this.installdata, null);
            }
        }
    }
}

