/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedRunner {
    private boolean vetoed = false;

    public PrivilegedRunner() {
    }

    public PrivilegedRunner(boolean vetoed) {
        this.vetoed = vetoed;
    }

    public boolean isVetoed() {
        return this.vetoed;
    }

    public boolean isPlatformSupported() {
        return OsVersion.IS_MAC || OsVersion.IS_UNIX || OsVersion.IS_WINDOWS;
    }

    public boolean isElevationNeeded() {
        if (this.vetoed) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            return !PrivilegedRunner.isPrivilegedMode() && !this.canWriteToProgramFiles();
        }
        return !System.getProperty("user.name").equals("root");
    }

    public boolean canWriteToProgramFiles() {
        try {
            File temp;
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null) {
                programFiles = "C:\\Program Files";
            }
            if ((temp = new File(programFiles, "foo.txt")).createNewFile()) {
                temp.delete();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int relaunchWithElevatedRights() throws IOException, InterruptedException {
        String javaCommand = this.getJavaCommand();
        String installer = this.getInstallerJar();
        ProcessBuilder builder = new ProcessBuilder(this.getElevator(javaCommand, installer));
        builder.environment().put("izpack.mode", "privileged");
        return builder.start().waitFor();
    }

    private List<String> getElevator(String javaCommand, String installer) throws IOException, InterruptedException {
        ArrayList<String> elevator = new ArrayList<String>();
        if (OsVersion.IS_OSX) {
            elevator.add(this.extractMacElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (OsVersion.IS_UNIX) {
            elevator.add("xterm");
            elevator.add("-title");
            elevator.add("Installer");
            elevator.add("-e");
            elevator.add("sudo");
            elevator.add(javaCommand);
            elevator.add("-jar");
            elevator.add(installer);
        } else if (OsVersion.IS_WINDOWS) {
            elevator.add("wscript");
            elevator.add(this.extractVistaElevator().getCanonicalPath());
            elevator.add(javaCommand);
            elevator.add("-Dizpack.mode=privileged");
            elevator.add("-jar");
            elevator.add(installer);
        }
        return elevator;
    }

    private File extractVistaElevator() throws IOException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer.js";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/elevate.js");
        this.copyStream(out, in);
        in.close();
        out.close();
        elevator.deleteOnExit();
        return elevator;
    }

    private File extractMacElevator() throws IOException, InterruptedException {
        String path = System.getProperty("java.io.tmpdir") + File.separator + "Installer";
        File elevator = new File(path);
        FileOutputStream out = new FileOutputStream(elevator);
        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/run-with-privileges-on-osx");
        this.copyStream(out, in);
        in.close();
        out.close();
        this.makeExecutable(path);
        elevator.deleteOnExit();
        return elevator;
    }

    private void makeExecutable(String path) throws InterruptedException, IOException {
        new ProcessBuilder("/bin/chmod", "+x", path).start().waitFor();
    }

    private void copyStream(OutputStream out, InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private String getInstallerJar() {
        try {
            URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uri.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uri);
            }
            return new File(uri.getSchemeSpecificPart()).getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getJavaCommand() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + this.getJavaExecutable();
    }

    private String getJavaExecutable() {
        if (OsVersion.IS_WINDOWS) {
            return "javaw.exe";
        }
        return "java";
    }

    public static boolean isPrivilegedMode() {
        return "privileged".equals(System.getenv("izpack.mode")) || "privileged".equals(System.getProperty("izpack.mode"));
    }
}

