/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JavaCondition
extends Condition {
    private static final long serialVersionUID = -7649870719815066537L;
    protected String classname;
    protected String methodname;
    protected String fieldname;
    protected boolean complete;
    protected String returnvalue;
    protected String returnvaluetype;
    protected Class usedclass;
    protected Field usedfield;
    protected Method usedmethod;

    public boolean isTrue() {
        if (!this.complete) {
            return false;
        }
        if (this.usedclass == null) {
            try {
                this.usedclass = Class.forName(this.classname);
            }
            catch (ClassNotFoundException e) {
                Debug.log("Can't find class " + this.classname);
                return false;
            }
        }
        if (this.usedfield == null && this.fieldname != null) {
            try {
                this.usedfield = this.usedclass.getField(this.fieldname);
            }
            catch (SecurityException e) {
                Debug.log("No permission to access specified field: " + this.fieldname);
                return false;
            }
            catch (NoSuchFieldException e) {
                Debug.log("No such field: " + this.fieldname);
                return false;
            }
        }
        if (this.usedmethod == null && this.methodname != null) {
            Debug.log("not implemented yet.");
            return false;
        }
        if (this.usedfield != null) {
            if ("boolean".equals(this.returnvaluetype)) {
                try {
                    boolean returnval = this.usedfield.getBoolean(null);
                    boolean expectedreturnval = Boolean.valueOf(this.returnvalue);
                    return returnval == expectedreturnval;
                }
                catch (IllegalArgumentException e) {
                    Debug.log("IllegalArgumentexeption " + this.fieldname);
                }
                catch (IllegalAccessException e) {
                    Debug.log("IllegalAccessException " + this.fieldname);
                }
            } else {
                Debug.log("not implemented yet.");
                return false;
            }
        }
        return false;
    }

    public void readFromXML(IXMLElement xmlcondition) {
        IXMLElement fieldel;
        if (xmlcondition.getChildrenCount() != 2) {
            Debug.log("Condition of type java needs (java,returnvalue)");
            return;
        }
        IXMLElement javael = xmlcondition.getFirstChildNamed("java");
        IXMLElement classel = javael.getFirstChildNamed("class");
        if (classel == null) {
            Debug.log("Java-Element needs (class,method?,field?)");
            return;
        }
        this.classname = classel.getContent();
        IXMLElement methodel = javael.getFirstChildNamed("method");
        if (methodel != null) {
            this.methodname = methodel.getContent();
        }
        if ((fieldel = javael.getFirstChildNamed("field")) != null) {
            this.fieldname = fieldel.getContent();
        }
        if (this.methodname == null && this.fieldname == null) {
            Debug.log("java element needs (class, method?,field?)");
            return;
        }
        IXMLElement returnvalel = xmlcondition.getFirstChildNamed("returnvalue");
        if (returnvalel == null) {
            Debug.log("no returnvalue-element specified.");
            return;
        }
        this.returnvalue = returnvalel.getContent();
        this.returnvaluetype = returnvalel.getAttribute("type");
        this.complete = true;
    }

    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl javael = new XMLElementImpl("java", conditionRoot);
        conditionRoot.addChild(javael);
        XMLElementImpl classel = new XMLElementImpl("class", javael);
        classel.setContent(this.classname);
        javael.addChild(classel);
        if (this.methodname != null) {
            XMLElementImpl methodel = new XMLElementImpl("method", javael);
            methodel.setContent(this.methodname);
            javael.addChild(methodel);
        }
        if (this.fieldname != null) {
            XMLElementImpl fieldel = new XMLElementImpl("field", javael);
            fieldel.setContent(this.fieldname);
            javael.addChild(fieldel);
        }
        XMLElementImpl returnvalel = new XMLElementImpl("returnvalue", javael);
        returnvalel.setContent(this.returnvalue);
        returnvalel.setAttribute("type", this.returnvaluetype);
        javael.addChild(returnvalel);
    }

    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on the ");
        if (this.fieldname != null) {
            details.append("value of field <b>");
            details.append(this.fieldname);
            details.append("</b>");
        } else {
            details.append("return value of method <b>");
            details.append(this.methodname);
            details.append("</b>");
        }
        details.append(" on an instance of class <b>");
        details.append(this.classname);
        details.append("</b> which should be <b>");
        details.append(this.returnvalue);
        details.append("</b><br/>");
        return details.toString();
    }
}

