/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class OrCondition
extends Condition {
    private static final long serialVersionUID = 8341350377205144199L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public OrCondition() {
    }

    public OrCondition(Condition operand1, Condition operand2, AutomatedInstallData installdata) {
        this.installdata = installdata;
        this.leftoperand = operand1;
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand = operand2;
        this.rightoperand.setInstalldata(this.installdata);
    }

    public void readFromXML(IXMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 2) {
                Debug.log("or-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(1));
        }
        catch (Exception e) {
            Debug.log("missing element in or-condition");
        }
    }

    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        return this.leftoperand.isTrue() || this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>");
        details.append(this.leftoperand.getDependenciesDetails());
        details.append("</li> OR <li>");
        details.append(this.rightoperand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    public void makeXMLData(IXMLElement conditionRoot) {
        IXMLElement left = RulesEngine.createConditionElement(this.leftoperand, conditionRoot);
        this.leftoperand.makeXMLData(left);
        conditionRoot.addChild(left);
        IXMLElement right = RulesEngine.createConditionElement(this.rightoperand, conditionRoot);
        this.rightoperand.makeXMLData(right);
        conditionRoot.addChild(right);
    }
}

