/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;

public class VariableExistenceCondition
extends Condition {
    private static final long serialVersionUID = -7424383017678759732L;
    private String variable = "default.variable";

    public boolean isTrue() {
        boolean result = false;
        String value = this.installdata.getVariable(this.variable);
        if (value != null) {
            result = true;
        }
        return result;
    }

    public void readFromXML(IXMLElement xmlcondition) {
        if (xmlcondition != null) {
            IXMLElement variableElement = xmlcondition.getFirstChildNamed("variable");
            if (variableElement != null) {
                this.variable = variableElement.getContent();
            } else {
                Debug.error("VariableExistenceCondition needs a variable element in its spec.");
            }
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl variableEl = new XMLElementImpl("variable", conditionRoot);
        variableEl.setContent(this.variable);
        conditionRoot.addChild(variableEl);
    }
}

