/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.installer.PrivilegedRunner;
import com.izforge.izpack.uninstaller.SelfModifier;
import com.izforge.izpack.uninstaller.UninstallerConsole;
import com.izforge.izpack.uninstaller.UninstallerFrame;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsVersion;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Uninstaller {
    public static void main(String[] args) {
        Uninstaller.checkForPrivilegedExecution();
        boolean cmduninstall = false;
        for (String arg : args) {
            if (!arg.equals("-c")) continue;
            cmduninstall = true;
        }
        if (cmduninstall) {
            System.out.println("Command line uninstaller.\n");
        }
        try {
            Class<Uninstaller> clazz = Uninstaller.class;
            Method target = cmduninstall ? clazz.getMethod("cmduninstall", String[].class) : clazz.getMethod("uninstall", String[].class);
            new SelfModifier(target).invoke(args);
        }
        catch (Exception ioeOrTypo) {
            System.err.println(ioeOrTypo.getMessage());
            ioeOrTypo.printStackTrace();
            System.err.println("Unable to exec java as a subprocess.");
            System.err.println("The uninstall may not fully complete.");
            Uninstaller.uninstall(args);
        }
    }

    private static void checkForPrivilegedExecution() {
        if (PrivilegedRunner.isPrivilegedMode()) {
            return;
        }
        if (Uninstaller.elevationShouldBeInvestigated()) {
            PrivilegedRunner runner = new PrivilegedRunner();
            if (runner.isPlatformSupported() && runner.isElevationNeeded()) {
                try {
                    if (runner.relaunchWithElevatedRights() != 0) {
                        throw new RuntimeException("Launching an uninstaller with elevated permissions failed.");
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The uninstaller could not launch itself with administrator permissions.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
                }
            } else if (!runner.isPlatformSupported()) {
                JOptionPane.showMessageDialog(null, "This uninstaller should be run by an administrator.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
            }
        }
    }

    private static boolean elevationShouldBeInvestigated() {
        return Uninstaller.class.getResource("/exec-admin") != null || OsVersion.IS_WINDOWS && !new PrivilegedRunner().canWriteToProgramFiles();
    }

    public static void cmduninstall(String[] args) {
        try {
            UninstallerConsole uco = new UninstallerConsole();
            boolean force = false;
            for (String arg : args) {
                if (!arg.equals("-f")) continue;
                force = true;
            }
            System.out.println("Force deletion: " + force);
            uco.runUninstall(force);
        }
        catch (Exception err) {
            System.err.println("- Error -");
            err.printStackTrace();
            Housekeeper.getInstance().shutDown(0);
        }
    }

    public static void uninstall(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    boolean displayForceOption = true;
                    boolean forceOptionState = false;
                    for (String arg : args) {
                        if (arg.equals("-f")) {
                            forceOptionState = true;
                            continue;
                        }
                        if (!arg.equals("-x")) continue;
                        displayForceOption = false;
                    }
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    new UninstallerFrame(displayForceOption, forceOptionState);
                }
                catch (Exception err) {
                    System.err.println("- Error -");
                    err.printStackTrace();
                    Housekeeper.getInstance().shutDown(0);
                }
            }
        });
    }
}

