/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.os.unix.UnixUser;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixUsers
extends ArrayList {
    private static final long serialVersionUID = -4804842346742194981L;

    public UnixUsers() {
        this.fromUsersArrayList(UnixUsers.getEtcPasswdUsersAsArrayList());
        this.fromUsersArrayList(UnixUsers.getYpPasswdUsersAsArrayList());
    }

    public ArrayList<UnixUser> getUsersWithValidShells() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        for (int idx = 0; idx < this.size(); ++idx) {
            UnixUser user = (UnixUser)this.get(idx);
            if (user.getShell() == null || !user.getShell().trim().endsWith("sh")) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<UnixUser> getUsersWithValidShellsAndExistingHomes() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        ArrayList<UnixUser> usersWithValidShells = this.getUsersWithValidShells();
        for (int idx = 0; idx < usersWithValidShells.size(); ++idx) {
            UnixUser user = usersWithValidShells.get(idx);
            if (user.getHome() == null || !new File(user.getHome().trim()).exists()) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList _getUsersWithValidShellsExistingHomesAndDesktops() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        ArrayList<UnixUser> usersWithValidShellsAndExistingHomes = this.getUsersWithValidShellsAndExistingHomes();
        for (int idx = 0; idx < usersWithValidShellsAndExistingHomes.size(); ++idx) {
            UnixUser user = usersWithValidShellsAndExistingHomes.get(idx);
            if (user.getHome() == null || !new File(user.getXdgDesktopfolder()).exists()) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<String> getValidUsersDesktopFolders() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList validUserDesktops = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        for (int idx = 0; idx < validUserDesktops.size(); ++idx) {
            File DesktopFolder;
            UnixUser user = (UnixUser)validUserDesktops.get(idx);
            if (user.getHome() == null || !(DesktopFolder = new File(user.getXdgDesktopfolder())).exists() || !DesktopFolder.isDirectory()) continue;
            result.add(DesktopFolder.toString());
        }
        return result;
    }

    public static ArrayList getUsersWithValidShellsExistingHomesAndDesktops() {
        UnixUsers users = new UnixUsers();
        return users._getUsersWithValidShellsExistingHomesAndDesktops();
    }

    private void fromUsersArrayList(ArrayList<String> anUsersArrayList) {
        for (int idx = 0; idx < anUsersArrayList.size(); ++idx) {
            this.add(new UnixUser().fromEtcPasswdLine(anUsersArrayList.get(idx)));
        }
    }

    public static ArrayList<String> getEtcPasswdUsersAsArrayList() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> etcPasswdArray = UnixHelper.getEtcPasswdArray();
        for (int idx = 0; idx < etcPasswdArray.size(); ++idx) {
            String line = etcPasswdArray.get(idx);
            result.add(line);
        }
        return result;
    }

    public static ArrayList<String> getYpPasswdUsersAsArrayList() {
        return UnixHelper.getYpPasswdArray();
    }

    public static String getUsersColonString() {
        ArrayList<String> usersArrayList = UnixUsers.getEtcPasswdUsersAsArrayList();
        String retValue = "";
        for (int user = 0; user < usersArrayList.size(); ++user) {
            String userline = usersArrayList.get(user);
            retValue = retValue + userline.substring(0, userline.indexOf(":")) + ":";
        }
        if (retValue.endsWith(":")) {
            retValue = retValue.substring(0, retValue.length() - 1);
        }
        return retValue;
    }

    public static void main(String[] args) {
        System.out.println("UnixUsers:");
        UnixUsers users = new UnixUsers();
        for (int idx = 0; idx < users.size(); ++idx) {
            System.out.println(((UnixUser)users.get(idx)).getName());
        }
        System.out.println(StringTool.stringArrayListToString(UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops()));
    }
}

