/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.types.selectors.MappingSelector;
import java.io.File;

public class DifferentSelector
extends MappingSelector {
    private FileUtils fileUtils = FileUtils.getFileUtils();
    private boolean ignoreFileTimes = true;
    private boolean ignoreContents = false;

    public void setIgnoreFileTimes(boolean ignoreFileTimes) {
        this.ignoreFileTimes = ignoreFileTimes;
    }

    public void setIgnoreContents(boolean ignoreContents) {
        this.ignoreContents = ignoreContents;
    }

    @Override
    protected boolean selectionTest(File srcfile, File destfile) {
        if (srcfile.exists() != destfile.exists()) {
            return true;
        }
        if (srcfile.length() != destfile.length()) {
            return true;
        }
        if (!this.ignoreFileTimes) {
            boolean sameDate;
            boolean bl = sameDate = destfile.lastModified() >= srcfile.lastModified() - (long)this.granularity && destfile.lastModified() <= srcfile.lastModified() + (long)this.granularity;
            if (!sameDate) {
                return true;
            }
        }
        if (!this.ignoreContents) {
            try {
                return !this.fileUtils.contentEquals(srcfile, destfile);
            }
            catch (Exception e) {
                throw new IzPackException("while comparing " + srcfile + " and " + destfile, (Throwable)e);
            }
        }
        return false;
    }
}

