/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.IdentityMapper;
import com.izforge.izpack.util.file.types.Mapper;
import com.izforge.izpack.util.file.types.selectors.BaseSelector;
import java.io.File;

public abstract class MappingSelector
extends BaseSelector {
    protected File targetdir = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper map = null;
    protected int granularity = (int)FileUtils.getFileUtils().getFileTimestampGranularity();

    public void setTargetdir(File targetdir) {
        this.targetdir = targetdir;
    }

    public Mapper createMapper() throws Exception {
        if (this.mapperElement != null) {
            throw new Exception("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper();
        return this.mapperElement;
    }

    @Override
    public void verifySettings() throws Exception {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    @Override
    public boolean isSelected(InstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        String[] destfiles = this.map.mapFileName(filename);
        if (destfiles == null) {
            return false;
        }
        if (destfiles.length != 1 || destfiles[0] == null) {
            throw new Exception("Invalid destination file results for " + this.targetdir.getName() + " with filename " + filename);
        }
        String destname = destfiles[0];
        File destfile = new File(this.targetdir, destname);
        boolean selected = this.selectionTest(file, destfile);
        return selected;
    }

    protected abstract boolean selectionTest(File var1, File var2);

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }
}

