/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.map.deser.Creator;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.PropertyValueBuffer;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonCachable
public class BeanDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    protected final JavaType _beanType;
    protected Constructor<?> _defaultConstructor;
    protected Creator.StringBased _stringCreator;
    protected Creator.NumberBased _numberCreator;
    protected Creator.Delegating _delegatingCreator;
    protected Creator.PropertyBased _propertyBasedCreator;
    protected final HashMap<String, SettableBeanProperty> _props;
    protected SettableAnyProperty _anySetter;
    protected HashSet<String> _ignorableProps;
    protected boolean _ignoreAllUnknown;

    public BeanDeserializer(JavaType type) {
        super(type.getRawClass());
        this._beanType = type;
        this._props = new HashMap();
        this._ignorableProps = null;
    }

    public void setDefaultConstructor(Constructor<?> ctor) {
        this._defaultConstructor = ctor;
    }

    public void setCreators(CreatorContainer creators) {
        this._stringCreator = creators.stringCreator();
        this._numberCreator = creators.numberCreator();
        this._delegatingCreator = creators.delegatingCreator();
        this._propertyBasedCreator = creators.propertyBasedCreator();
        if (this._delegatingCreator != null || this._propertyBasedCreator != null) {
            this._defaultConstructor = null;
        }
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._props.put(prop.getPropertyName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getPropertyName() + "' for " + this._beanType);
        }
    }

    public SettableBeanProperty removeProperty(String name) {
        return this._props.remove(name);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void setIgnoreUnknownProperties(boolean ignore) {
        this._ignoreAllUnknown = ignore;
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void validateCreators() throws JsonMappingException {
        if (this._defaultConstructor == null && this._numberCreator == null && this._stringCreator == null && this._delegatingCreator == null && this._propertyBasedCreator == null) {
            throw new JsonMappingException("Can not create Bean deserializer for (" + this._beanType + "): neither default/delegating constructor nor factory methods found");
        }
    }

    @Override
    public void resolve(DeserializationConfig config, DeserializerProvider provider) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> seen = new HashMap<JavaType, JsonDeserializer<Object>>();
        for (SettableBeanProperty prop : this._props.values()) {
            if (prop.hasValueDeserializer()) continue;
            prop.setValueDeserializer(this.findDeserializer(config, provider, prop.getType(), prop.getPropertyName(), seen));
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            this._anySetter.setValueDeserializer(this.findDeserializer(config, provider, this._anySetter.getType(), "[any]", seen));
        }
        if (this._delegatingCreator != null) {
            JsonDeserializer<Object> deser = this.findDeserializer(config, provider, this._delegatingCreator.getValueType(), "[constructor-arg[0]]", seen);
            this._delegatingCreator.setDeserializer(deser);
        }
        if (this._propertyBasedCreator != null) {
            for (SettableBeanProperty prop : this._propertyBasedCreator.properties()) {
                prop.setValueDeserializer(this.findDeserializer(config, provider, prop.getType(), prop.getPropertyName(), seen));
            }
        }
    }

    @Override
    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            return this.deserializeFromObject(jp, ctxt);
        }
        switch (t) {
            case VALUE_STRING: {
                return this.deserializeFromString(jp, ctxt);
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this.deserializeFromNumber(jp, ctxt);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jp.getEmbeddedObject();
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case START_ARRAY: {
                return this.deserializeUsingCreator(jp, ctxt);
            }
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._beanType;
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        if (this._defaultConstructor == null) {
            if (this._propertyBasedCreator != null) {
                return this._deserializeUsingPropertyBased(jp, ctxt);
            }
            if (this._delegatingCreator != null) {
                return this._delegatingCreator.deserialize(jp, ctxt);
            }
            throw JsonMappingException.from(jp, "No default constructor found for type " + this._beanType + ": can not instantiate from Json object");
        }
        try {
            bean = this._defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE(e);
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, bean, propName);
        }
        return bean;
    }

    public Object deserializeFromString(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._stringCreator != null) {
            return this._stringCreator.construct(jp.getText());
        }
        if (this._delegatingCreator != null) {
            return this._delegatingCreator.deserialize(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public Object deserializeFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._numberCreator != null) {
            switch (jp.getNumberType()) {
                case INT: {
                    return this._numberCreator.construct(jp.getIntValue());
                }
                case LONG: {
                    return this._numberCreator.construct(jp.getLongValue());
                }
            }
        }
        if (this._delegatingCreator != null) {
            return this._delegatingCreator.deserialize(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    public Object deserializeUsingCreator(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._delegatingCreator != null) {
            return this._delegatingCreator.deserialize(jp, ctxt);
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    protected final Object _deserializeUsingPropertyBased(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Creator.PropertyBased creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(jp, ctxt);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = creator.findCreatorProperty(propName);
            if (prop != null) {
                if (!buffer.assignParameter(prop.getCreatorIndex(), prop.deserialize(jp, ctxt))) continue;
                return this._deserializeProperties(jp, ctxt, creator.build(buffer));
            }
            prop = this._props.get(propName);
            if (prop != null) {
                buffer.bufferProperty(prop, prop.deserialize(jp, ctxt));
                continue;
            }
            if (this._anySetter != null) {
                buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(jp, ctxt));
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, this.getBeanClass(), propName);
        }
        return creator.build(buffer);
    }

    protected Object _deserializeProperties(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._props.get(propName);
            if (prop != null) {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                continue;
            }
            jp.nextToken();
            this.handleUnknownProperty(ctxt, bean, propName);
        }
        return bean;
    }

    @Override
    protected void handleUnknownProperty(DeserializationContext ctxt, Object beanOrClass, String propName) throws IOException, JsonProcessingException {
        if (this._ignoreAllUnknown || this._ignorableProps != null && this._ignorableProps.contains(propName)) {
            ctxt.getParser().skipChildren();
            return;
        }
        super.handleUnknownProperty(ctxt, beanOrClass, propName);
    }
}

