/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.ClassKey;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDeserializerFactory
extends BeanDeserializerFactory {
    protected HashMap<ClassKey, JsonDeserializer<Object>> _directClassMappings = null;
    protected HashMap<ClassKey, Class<?>> _mixInAnnotations;

    public <T> void addSpecificMapping(Class<T> forClass, JsonDeserializer<? extends T> deser) {
        ClassKey key = new ClassKey(forClass);
        if (this._directClassMappings == null) {
            this._directClassMappings = new HashMap();
        }
        this._directClassMappings.put(key, deser);
    }

    public void addMixInAnnotationMapping(Class<?> destinationClass, Class<?> classWithMixIns) {
        if (this._mixInAnnotations == null) {
            this._mixInAnnotations = new HashMap();
        }
        this._mixInAnnotations.put(new ClassKey(destinationClass), classWithMixIns);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, JavaType type, DeserializerProvider p) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        Class cls = type.getRawClass();
        ClassKey key = new ClassKey(cls);
        if (this._directClassMappings != null && (deser = this._directClassMappings.get(key)) != null) {
            return deser;
        }
        return super.createBeanDeserializer(config, type, p);
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationConfig config, ArrayType type, DeserializerProvider p) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        Class cls = type.getRawClass();
        ClassKey key = new ClassKey(cls);
        if (this._directClassMappings != null && (deser = this._directClassMappings.get(key)) != null) {
            return deser;
        }
        return super.createArrayDeserializer(config, type, p);
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationConfig config, Class<?> enumClass, DeserializerProvider p) throws JsonMappingException {
        ClassKey key;
        JsonDeserializer<Object> deser;
        if (this._directClassMappings != null && (deser = this._directClassMappings.get(key = new ClassKey(enumClass))) != null) {
            return deser;
        }
        return super.createEnumDeserializer(config, enumClass, p);
    }
}

