/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.jpox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.db.SQLReservedWords;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.jpox.metadata.JPoxAssociationMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxClassMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxFieldMetadata;
import org.codehaus.modello.plugin.jpox.metadata.JPoxModelMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreAssociationMetadata;
import org.codehaus.modello.plugin.store.metadata.StoreFieldMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JPoxJdoMappingModelloGenerator
extends AbstractModelloGenerator {
    private static final char EOL = '\n';
    private static final String ERROR_LINE = "----------------------------------------------------------------";
    private static final Map PRIMITIVE_IDENTITY_MAP = new HashMap();
    private static final List IDENTITY_TYPES;
    private static final List VALUE_STRATEGY_LIST;
    private SQLReservedWords sqlReservedWords;
    private String valueStrategyOverride;
    private String objectIdClassOverride;

    protected void initialize(Model model, Properties parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.valueStrategyOverride = parameters.getProperty("JPOX.override.value-strategy");
        this.objectIdClassOverride = parameters.getProperty("JPOX.override.objectid-class");
    }

    public void generate(Model model, Properties properties) throws ModelloException {
        this.initialize(model, properties);
        try {
            String fileName = properties.getProperty("modello.output.filename", "package.jdo");
            JPoxModelMetadata metadata = (JPoxModelMetadata)model.getMetadata(JPoxModelMetadata.ID);
            File packageJdo = null;
            if (metadata.isMappingInPackage()) {
                String packageName = model.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
                String dir = StringUtils.replace((String)packageName, (char)'.', (char)'/');
                File directory = new File(this.getOutputDirectory(), dir);
                packageJdo = new File(directory, fileName);
            } else {
                File directory = this.getOutputDirectory();
                packageJdo = new File(directory, fileName);
            }
            File parent = packageJdo.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new ModelloException("Error while creating parent directories for the file '" + packageJdo.getAbsolutePath() + "'.");
            }
            this.generatePackageJdo(packageJdo, model);
        }
        catch (IOException e) {
            throw new ModelloException("Error while writing package.jdo.", (Throwable)e);
        }
    }

    private void generatePackageJdo(File file, Model model) throws IOException, ModelloException {
        String packageName;
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter(printWriter);
        HashMap<String, ArrayList<ModelClass>> classes = new HashMap<String, ArrayList<ModelClass>>();
        Iterator<Object> it = model.getClasses(this.getGeneratedVersion()).iterator();
        while (it.hasNext()) {
            ModelClass modelClass = (ModelClass)it.next();
            JPoxClassMetadata jpoxMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
            if (!jpoxMetadata.isEnabled()) continue;
            packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            ArrayList<ModelClass> list = (ArrayList<ModelClass>)classes.get(packageName);
            if (list == null) {
                list = new ArrayList<ModelClass>();
            }
            list.add(modelClass);
            classes.put(packageName, list);
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        printWriter.println("<!DOCTYPE jdo PUBLIC");
        printWriter.println("  \"-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.0//EN\"");
        printWriter.println("  \"http://java.sun.com/dtd/jdo_2_0.dtd\">");
        printWriter.println();
        writer.startElement("jdo");
        it = classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            List list = (List)entry.getValue();
            if (list.size() == 0) continue;
            packageName = (String)entry.getKey();
            writer.startElement("package");
            writer.addAttribute("name", packageName);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                ModelClass modelClass = (ModelClass)it2.next();
                this.writeClass((XMLWriter)writer, modelClass);
            }
            if (packageName.equals(model.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()))) {
                this.writeModelloMetadataClass((XMLWriter)writer);
            }
            writer.endElement();
        }
        writer.endElement();
        printWriter.println();
        printWriter.close();
    }

    private void writeClass(XMLWriter writer, ModelClass modelClass) throws ModelloException {
        ModelField modelField;
        JPoxClassMetadata jpoxMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        if (!jpoxMetadata.isEnabled()) {
            return;
        }
        writer.startElement("class");
        writer.addAttribute("name", modelClass.getName());
        ModelClass persistenceCapableSuperclass = null;
        if (modelClass.hasSuperClass() && modelClass.isInternalSuperClass()) {
            persistenceCapableSuperclass = this.getModel().getClass(modelClass.getSuperClass(), this.getGeneratedVersion());
        }
        if (persistenceCapableSuperclass != null) {
            String superPackageName = persistenceCapableSuperclass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            writer.addAttribute("persistence-capable-superclass", superPackageName + "." + persistenceCapableSuperclass.getName());
        }
        writer.addAttribute("detachable", String.valueOf(jpoxMetadata.isDetachable()));
        writer.addAttribute("table", this.getTableName(modelClass, jpoxMetadata));
        List fields = Collections.unmodifiableList(modelClass.getFields(this.getGeneratedVersion()));
        boolean needInheritance = false;
        if (persistenceCapableSuperclass == null) {
            if (StringUtils.isNotEmpty((String)jpoxMetadata.getIdentityType())) {
                String identityType = jpoxMetadata.getIdentityType();
                if (!IDENTITY_TYPES.contains(identityType)) {
                    throw new ModelloException("The JDO mapping generator does not support the specified class identity type '" + identityType + "'. " + "Supported types: " + IDENTITY_TYPES);
                }
                writer.addAttribute("identity-type", identityType);
            } else if (this.isInstantionApplicationType(modelClass)) {
                writer.addAttribute("identity-type", "application");
            }
        } else {
            needInheritance = true;
        }
        if (this.objectIdClassOverride != null) {
            if (StringUtils.isNotEmpty((String)this.objectIdClassOverride)) {
                writer.addAttribute("objectid-class", jpoxMetadata.getIdentityClass());
            }
        } else if (StringUtils.isNotEmpty((String)jpoxMetadata.getIdentityClass())) {
            writer.addAttribute("objectid-class", jpoxMetadata.getIdentityClass());
        } else {
            String objectIdClass;
            List primaryKeys = this.getPrimaryKeyFields(modelClass);
            if (primaryKeys.size() > 1) {
                throw new ModelloException("The JDO mapping generator does not yet support Object Identifier generation for the " + primaryKeys.size() + " fields specified as <identifier> or " + "with jpox.primary-key=\"true\"");
            }
            if (primaryKeys.size() == 1 && StringUtils.isNotEmpty((String)(objectIdClass = (String)PRIMITIVE_IDENTITY_MAP.get((modelField = (ModelField)primaryKeys.get(0)).getType())))) {
                writer.addAttribute("objectid-class", objectIdClass);
            }
        }
        if (needInheritance) {
            writer.startElement("inheritance");
            writer.addAttribute("strategy", "new-table");
            writer.endElement();
        }
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            modelField = (ModelField)it.next();
            this.writeModelField(writer, modelField);
        }
        List ignoredFields = jpoxMetadata.getNotPersisted();
        if (ignoredFields != null) {
            Iterator it2 = ignoredFields.iterator();
            while (it2.hasNext()) {
                String fieldName = (String)it2.next();
                writer.startElement("field");
                writer.addAttribute("name", fieldName);
                writer.addAttribute("persistence-modifier", "none");
                writer.endElement();
            }
        }
        ArrayList<ModelField> detailedFields = new ArrayList<ModelField>();
        Iterator it3 = fields.iterator();
        while (it3.hasNext()) {
            StoreAssociationMetadata storeMetadata;
            ModelField field = (ModelField)it3.next();
            if (field.isPrimitive() || field instanceof ModelAssociation && (storeMetadata = this.getAssociationMetadata((ModelAssociation)field)).isPart() != null && storeMetadata.isPart().booleanValue()) continue;
            detailedFields.add(field);
        }
        this.writeFetchGroup(writer, modelClass.getName() + "_detail", detailedFields, true);
        HashMap fetchsMap = new HashMap();
        Iterator<Object> it4 = fields.iterator();
        while (it4.hasNext()) {
            ModelField field = (ModelField)it4.next();
            JPoxFieldMetadata jpoxFieldMetadata = (JPoxFieldMetadata)field.getMetadata(JPoxFieldMetadata.ID);
            List names = jpoxFieldMetadata.getFetchGroupNames();
            if (names == null) continue;
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String fetchGroupName = (String)i.next();
                List fetchList = fetchsMap.get(fetchGroupName) == null ? new ArrayList() : (List)fetchsMap.get(fetchGroupName);
                fetchList.add(field);
                fetchsMap.put(fetchGroupName, fetchList);
            }
        }
        it4 = fetchsMap.keySet().iterator();
        while (it4.hasNext()) {
            String fetchName = (String)it4.next();
            this.writeFetchGroup(writer, fetchName, (List)fetchsMap.get(fetchName), false);
        }
        writer.endElement();
    }

    private String getTableName(ModelClass modelClass, JPoxClassMetadata classMetadata) throws ModelloException {
        JPoxModelMetadata modelMetadata = (JPoxModelMetadata)modelClass.getModel().getMetadata(JPoxModelMetadata.ID);
        boolean hasPrefix = StringUtils.isNotEmpty((String)modelMetadata.getTablePrefix());
        boolean hasAlternateName = StringUtils.isNotEmpty((String)classMetadata.getTable());
        String prefix = "";
        if (hasPrefix) {
            prefix = modelMetadata.getTablePrefix().trim();
        }
        String tableName = null;
        tableName = hasAlternateName ? prefix + classMetadata.getTable() : prefix + modelClass.getName();
        if (this.sqlReservedWords.isKeyword(tableName)) {
            StringBuffer emsg = new StringBuffer();
            emsg.append('\n').append(ERROR_LINE).append('\n');
            emsg.append("  SQL Reserved Word Violation: ").append(tableName).append('\n');
            emsg.append("  Context: TABLE NAME").append('\n');
            emsg.append(" ").append('\n');
            emsg.append("  In Model:").append('\n');
            emsg.append("    <model");
            if (hasPrefix) {
                emsg.append(" jpox.table-prefix=\"").append(modelMetadata.getTablePrefix()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("      <class");
            if (hasAlternateName) {
                emsg.append(" jpox.table=\"").append(classMetadata.getTable()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("        <name>").append(modelClass.getName()).append("</name>").append('\n');
            emsg.append("      </class>").append('\n');
            emsg.append("    </model>").append('\n');
            emsg.append(" ").append('\n');
            boolean hasError = this.appendKeywordSourceViolations(tableName, emsg);
            emsg.append("  Suggestions: 1) Use a different prefix in").append('\n');
            emsg.append("                  <model jpox.table-prefix=\"DIFFERENT_\">").append('\n');
            emsg.append("               2) Use a different alternate table name using").append('\n');
            emsg.append("                  <class jpox.table=\"DIFFERENT\">").append('\n');
            emsg.append("               3) Use a different class name in").append('\n');
            emsg.append("                  <class>").append('\n');
            emsg.append("                    <name>DIFFERENT</name>").append('\n');
            emsg.append("                  </class>").append('\n');
            emsg.append(ERROR_LINE);
            if (hasError || modelMetadata.getReservedWordStrictness().equals("warning")) {
                throw new ModelloException(emsg.toString());
            }
            this.getLogger().warn(emsg.toString());
        }
        return tableName;
    }

    private boolean appendKeywordSourceViolations(String word, StringBuffer emsg) {
        List sources = this.sqlReservedWords.getKeywordSourceList(word);
        boolean hasError = false;
        emsg.append("  Violation Source(s): ");
        Iterator it = sources.iterator();
        while (it.hasNext()) {
            SQLReservedWords.KeywordSource source = (SQLReservedWords.KeywordSource)it.next();
            emsg.append(source.getName()).append(" (").append(source.getSeverity()).append(")");
            emsg.append('\n');
            if (source.getSeverity().equalsIgnoreCase("ERROR")) {
                hasError = true;
            }
            if (!it.hasNext()) continue;
            emsg.append("                       ");
        }
        emsg.append(" ").append('\n');
        emsg.append("  Severity: ");
        if (hasError) {
            emsg.append("ERROR - You must change this name for the maximum").append('\n');
            emsg.append("            compatibility amoungst JDBC SQL Servers.").append('\n');
        } else {
            emsg.append("WARNING - You are encouraged to change this name").append('\n');
            emsg.append("            for maximum compatibility amoungst JDBC SQL Servers.").append('\n');
        }
        emsg.append(" ").append('\n');
        return hasError;
    }

    private void writeModelloMetadataClass(XMLWriter writer) throws ModelloException {
        writer.startElement("class");
        writer.addAttribute("name", this.getModel().getName() + "ModelloMetadata");
        writer.addAttribute("detachable", String.valueOf(true));
        writer.startElement("field");
        writer.addAttribute("name", "modelVersion");
        writer.addAttribute("null-value", "default");
        writer.startElement("column");
        writer.addAttribute("default-value", this.getGeneratedVersion().toString());
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    private void writeFetchGroup(XMLWriter writer, String fetchGroupName, List fields, boolean onlyIfIsStashPart) {
        if (!fields.isEmpty()) {
            writer.startElement("fetch-group");
            writer.addAttribute("name", fetchGroupName);
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                StoreAssociationMetadata storeMetadata;
                ModelField field = (ModelField)it.next();
                if (onlyIfIsStashPart && field instanceof ModelAssociation && (storeMetadata = this.getAssociationMetadata((ModelAssociation)field)).isPart() != null && storeMetadata.isPart().booleanValue()) continue;
                writer.startElement("field");
                writer.addAttribute("name", field.getName());
                writer.endElement();
            }
            writer.endElement();
        }
    }

    private void writeModelField(XMLWriter writer, ModelField modelField) throws ModelloException {
        writer.startElement("field");
        StoreFieldMetadata storeMetadata = (StoreFieldMetadata)modelField.getMetadata(StoreFieldMetadata.ID);
        JPoxFieldMetadata jpoxMetadata = (JPoxFieldMetadata)modelField.getMetadata(JPoxFieldMetadata.ID);
        writer.addAttribute("name", modelField.getName());
        if (!storeMetadata.isStorable()) {
            writer.addAttribute("persistence-modifier", "none");
        } else if (StringUtils.isNotEmpty((String)jpoxMetadata.getPersistenceModifier())) {
            writer.addAttribute("persistence-modifier", jpoxMetadata.getPersistenceModifier());
        }
        if (modelField.isRequired()) {
            writer.addAttribute("null-value", "exception");
        } else if (jpoxMetadata.getNullValue() != null) {
            writer.addAttribute("null-value", jpoxMetadata.getNullValue());
        }
        String columnName = this.getColumnName(modelField, jpoxMetadata);
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getJoinTableName())) {
            writer.addAttribute("table", this.getJoinTableName(modelField, jpoxMetadata));
        }
        if (jpoxMetadata.isPrimaryKey()) {
            writer.addAttribute("primary-key", "true");
            if (StringUtils.isNotEmpty((String)this.valueStrategyOverride)) {
                JPoxJdoMappingModelloGenerator.writeValueStrategy(this.valueStrategyOverride, writer);
            } else if (StringUtils.isNotEmpty((String)jpoxMetadata.getValueStrategy())) {
                JPoxJdoMappingModelloGenerator.writeValueStrategy(jpoxMetadata.getValueStrategy(), writer);
            }
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getIndexed())) {
            writer.addAttribute("indexed", jpoxMetadata.getIndexed());
        }
        if (StringUtils.isNotEmpty((String)jpoxMetadata.getMappedBy())) {
            writer.addAttribute("mapped-by", jpoxMetadata.getMappedBy());
        }
        if (modelField instanceof ModelAssociation) {
            this.writeAssociation(writer, (ModelAssociation)modelField);
        } else {
            if (modelField.isPrimitiveArray()) {
                writer.startElement("array");
                writer.endElement();
            }
            Properties columnProps = new Properties();
            if (!StringUtils.equalsIgnoreCase((String)columnName, (String)modelField.getName())) {
                columnProps.setProperty("name", columnName);
            }
            if (storeMetadata.getMaxSize() > 0) {
                columnProps.setProperty("length", String.valueOf(storeMetadata.getMaxSize()));
            }
            if (StringUtils.equals((String)jpoxMetadata.getNullValue(), (String)"default")) {
                columnProps.setProperty("default-value", modelField.getDefaultValue());
            }
            if (!((Hashtable)columnProps).isEmpty()) {
                writer.startElement("column");
                Enumeration<?> en = columnProps.propertyNames();
                while (en.hasMoreElements()) {
                    String attributeName = (String)en.nextElement();
                    String attributeValue = columnProps.getProperty(attributeName);
                    writer.addAttribute(attributeName, attributeValue);
                }
                writer.endElement();
            }
            if (jpoxMetadata.isUnique()) {
                writer.startElement("unique");
                writer.addAttribute("name", columnName.toUpperCase() + "_UNIQUE_CONSTRAINT");
                writer.endElement();
            }
            if (jpoxMetadata.isForeignKey()) {
                writer.startElement("foreign-key");
                writer.addAttribute("name", columnName.toUpperCase() + "_FK");
                if (StringUtils.isNotEmpty((String)jpoxMetadata.getForeignKeyDeferred())) {
                    writer.addAttribute("deferred", jpoxMetadata.getForeignKeyDeferred());
                }
                if (StringUtils.isNotEmpty((String)jpoxMetadata.getForeignKeyDeleteAction())) {
                    writer.addAttribute("delete-action", jpoxMetadata.getForeignKeyDeleteAction());
                }
                if (StringUtils.isNotEmpty((String)jpoxMetadata.getForeignKeyUpdateAction())) {
                    writer.addAttribute("update-action", jpoxMetadata.getForeignKeyUpdateAction());
                }
                writer.endElement();
            }
        }
        writer.endElement();
    }

    private String getJoinTableName(ModelField modelField, JPoxFieldMetadata fieldMetadata) throws ModelloException {
        String joinTableName;
        ModelClass modelClass = modelField.getModelClass();
        JPoxModelMetadata modelMetadata = (JPoxModelMetadata)modelClass.getModel().getMetadata(JPoxModelMetadata.ID);
        boolean hasPrefix = StringUtils.isNotEmpty((String)modelMetadata.getTablePrefix());
        String prefix = "";
        if (hasPrefix) {
            prefix = modelMetadata.getTablePrefix().trim();
        }
        if (this.sqlReservedWords.isKeyword(joinTableName = prefix + fieldMetadata.getJoinTableName())) {
            StringBuffer emsg = new StringBuffer();
            emsg.append('\n').append(ERROR_LINE).append('\n');
            emsg.append("  SQL Reserved Word Violation: ").append(joinTableName).append('\n');
            emsg.append("  Context: JOIN TABLE NAME").append('\n');
            emsg.append(" ").append('\n');
            emsg.append("  In Model:").append('\n');
            emsg.append("    <model");
            if (hasPrefix) {
                emsg.append(" jpox.table-prefix=\"").append(modelMetadata.getTablePrefix()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("      <class>").append('\n');
            emsg.append("        <name>").append(modelClass.getName()).append("</name>").append('\n');
            emsg.append("        <fields>").append('\n');
            emsg.append("          <field jpox.join-table=\"").append(fieldMetadata.getJoinTableName());
            emsg.append("\">").append('\n');
            emsg.append("            <name>").append(modelField.getName()).append("</name>").append('\n');
            emsg.append("          <field>").append('\n');
            emsg.append("        </fields>").append('\n');
            emsg.append("      </class>").append('\n');
            emsg.append("    </model>").append('\n');
            emsg.append(" ").append('\n');
            boolean hasError = this.appendKeywordSourceViolations(joinTableName, emsg);
            emsg.append("  Suggestions: 1) Use a different table prefix in").append('\n');
            emsg.append("                  <model jpox.table-prefix=\"DIFFERENT_\">").append('\n');
            emsg.append("               2) Use a different join table name using").append('\n');
            emsg.append("                  <field jpox.join-table=\"DIFFERENT\">").append('\n');
            emsg.append(ERROR_LINE);
            if (hasError || modelMetadata.getReservedWordStrictness().equals("warning")) {
                throw new ModelloException(emsg.toString());
            }
            this.getLogger().warn(emsg.toString());
        }
        return joinTableName;
    }

    private String getColumnName(ModelField modelField, JPoxFieldMetadata fieldMetadata) throws ModelloException {
        boolean hasClassPrefix = false;
        boolean hasModelPrefix = false;
        boolean hasAlternateName = false;
        ModelClass modelClass = modelField.getModelClass();
        JPoxClassMetadata classMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        JPoxModelMetadata modelMetadata = (JPoxModelMetadata)modelClass.getModel().getMetadata(JPoxModelMetadata.ID);
        String prefix = "";
        if (StringUtils.isNotEmpty((String)modelMetadata.getColumnPrefix())) {
            prefix = modelMetadata.getColumnPrefix().trim();
            hasModelPrefix = true;
        }
        if (StringUtils.isNotEmpty((String)classMetadata.getColumnPrefix())) {
            prefix = classMetadata.getColumnPrefix();
            hasClassPrefix = true;
        }
        String columnName = "";
        if (StringUtils.isNotEmpty((String)fieldMetadata.getColumnName())) {
            columnName = prefix + fieldMetadata.getColumnName();
            hasAlternateName = true;
        } else {
            columnName = prefix + modelField.getName();
        }
        if (this.sqlReservedWords.isKeyword(columnName)) {
            StringBuffer emsg = new StringBuffer();
            emsg.append('\n').append(ERROR_LINE).append('\n');
            emsg.append("  SQL Reserved Word Violation: ").append(columnName).append('\n');
            emsg.append("  Context: COLUMN NAME").append('\n');
            emsg.append(" ").append('\n');
            emsg.append("  In Model:").append('\n');
            emsg.append("    <model");
            if (hasModelPrefix) {
                emsg.append(" jpox.column-prefix=\"").append(modelMetadata.getColumnPrefix()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("      <class");
            if (hasClassPrefix) {
                emsg.append(" jpox.column-prefix=\"").append(classMetadata.getColumnPrefix()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("        <name>").append(modelClass.getName()).append("</name>").append('\n');
            emsg.append("        <fields>").append('\n');
            emsg.append("          <field");
            if (hasAlternateName) {
                emsg.append(" jpox.column=\"").append(fieldMetadata.getColumnName()).append("\"");
            }
            emsg.append(">").append('\n');
            emsg.append("            <name>").append(modelField.getName()).append("</name>").append('\n');
            emsg.append("          <field>").append('\n');
            emsg.append("        </fields>").append('\n');
            emsg.append("      </class>").append('\n');
            emsg.append("    </model>").append('\n');
            emsg.append(" ").append('\n');
            boolean hasError = this.appendKeywordSourceViolations(columnName, emsg);
            emsg.append("  Suggestions: 1) Use a different model column prefix in").append('\n');
            emsg.append("                  <model jpox.column-prefix=\"DIFFERENT_\">").append('\n');
            emsg.append("               2) Use a different class column prefix in").append('\n');
            emsg.append("                  <class jpox.column-prefix=\"DIFFERENT_\">").append('\n');
            emsg.append("               3) Use a different alternate column name using").append('\n');
            emsg.append("                  <field jpox.column=\"DIFFERENT\">").append('\n');
            emsg.append("               4) Use a different field name in").append('\n');
            emsg.append("                  <class>").append('\n');
            emsg.append("                    <name>").append(modelClass.getName()).append("</name>").append('\n');
            emsg.append("                    <fields>").append('\n');
            emsg.append("                      <field>").append('\n');
            emsg.append("                        <name>DIFFERENT</name>").append('\n');
            emsg.append("                      <field>").append('\n');
            emsg.append("                    </fields>").append('\n');
            emsg.append("                  </class>").append('\n');
            emsg.append(ERROR_LINE);
            if (hasError || modelMetadata.getReservedWordStrictness().equals("warning")) {
                throw new ModelloException(emsg.toString());
            }
            this.getLogger().warn(emsg.toString());
        }
        return columnName;
    }

    private static void writeValueStrategy(String valueStrategy, XMLWriter writer) throws ModelloException {
        if (!"off".equals(valueStrategy)) {
            if (!VALUE_STRATEGY_LIST.contains(valueStrategy)) {
                throw new ModelloException("The JDO mapping generator does not support the specified value-strategy '" + valueStrategy + "'. " + "Supported types: " + VALUE_STRATEGY_LIST);
            }
            writer.addAttribute("value-strategy", valueStrategy);
        }
    }

    private void writeAssociation(XMLWriter writer, ModelAssociation association) {
        StoreAssociationMetadata am = (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
        JPoxAssociationMetadata jpoxMetadata = (JPoxAssociationMetadata)association.getAssociationMetadata(JPoxAssociationMetadata.ID);
        if (am.isPart() != null) {
            writer.addAttribute("default-fetch-group", am.isPart().toString());
        }
        if (association.getType().equals("java.util.List") || association.getType().equals("java.util.Set")) {
            writer.startElement("collection");
            if (association.getTo().equals("String")) {
                writer.addAttribute("element-type", "java.lang.String");
            } else {
                writer.addAttribute("element-type", association.getTo());
            }
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-element", "true");
            } else {
                writer.addAttribute("dependent-element", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Map")) {
            writer.startElement("map");
            writer.addAttribute("key-type", am.getKeyType());
            if (association.getTo().equals("String")) {
                writer.addAttribute("value-type", "java.lang.String");
            } else {
                writer.addAttribute("value-type", association.getTo());
            }
            if (jpoxMetadata.isDependent()) {
                writer.addAttribute("dependent-key", "true");
                writer.addAttribute("dependent-value", "true");
            } else {
                writer.addAttribute("dependent-key", "false");
                writer.addAttribute("dependent-value", "false");
            }
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (association.getType().equals("java.util.Properties")) {
            writer.addAttribute("embedded", "false");
            writer.startElement("map");
            writer.addAttribute("key-type", "java.lang.String");
            writer.addAttribute("value-type", "java.lang.String");
            writer.addAttribute("embedded-key", "true");
            writer.addAttribute("embedded-value", "true");
            writer.addAttribute("dependent-key", "true");
            writer.addAttribute("dependent-value", "true");
            writer.endElement();
            if (jpoxMetadata.isJoin()) {
                writer.startElement("join");
                writer.endElement();
            }
        } else if (jpoxMetadata.isDependent()) {
            writer.addAttribute("dependent", "true");
        }
    }

    private boolean isInstantionApplicationType(ModelClass modelClass) {
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        return identifierFields.size() > 0;
    }

    private List getPrimaryKeyFields(ModelClass modelClass) throws ModelloException {
        ArrayList<ModelField> primaryKeys = new ArrayList<ModelField>();
        List fields = modelClass.getFields(this.getGeneratedVersion());
        JPoxClassMetadata jpoxClassMetadata = (JPoxClassMetadata)modelClass.getMetadata(JPoxClassMetadata.ID);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            ModelField modelField = (ModelField)it.next();
            JPoxFieldMetadata jpoxFieldMetadata = (JPoxFieldMetadata)modelField.getMetadata(JPoxFieldMetadata.ID);
            if (jpoxClassMetadata.useIdentifiersAsPrimaryKey()) {
                if (!modelField.isIdentifier()) continue;
                this.assertSupportedIdentityPrimitive(modelField);
                primaryKeys.add(modelField);
                continue;
            }
            if (!jpoxFieldMetadata.isPrimaryKey()) continue;
            this.assertSupportedIdentityPrimitive(modelField);
            primaryKeys.add(modelField);
        }
        return primaryKeys;
    }

    private void assertSupportedIdentityPrimitive(ModelField modelField) throws ModelloException {
        if (!PRIMITIVE_IDENTITY_MAP.containsKey(modelField.getType())) {
            throw new ModelloException("The JDO mapping generator does not support the specified field type '" + modelField.getType() + "'. " + "Supported types: " + PRIMITIVE_IDENTITY_MAP.keySet());
        }
    }

    private StoreAssociationMetadata getAssociationMetadata(ModelAssociation association) {
        return (StoreAssociationMetadata)association.getAssociationMetadata(StoreAssociationMetadata.ID);
    }

    static {
        PRIMITIVE_IDENTITY_MAP.put("short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Short", "javax.jdo.identity.ShortIdentity");
        PRIMITIVE_IDENTITY_MAP.put("int", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Integer", "javax.jdo.identity.IntIdentity");
        PRIMITIVE_IDENTITY_MAP.put("long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Long", "javax.jdo.identity.LongIdentity");
        PRIMITIVE_IDENTITY_MAP.put("String", "javax.jdo.identity.StringIdentity");
        PRIMITIVE_IDENTITY_MAP.put("char", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Character", "javax.jdo.identity.CharIdentity");
        PRIMITIVE_IDENTITY_MAP.put("byte", "javax.jdo.identity.ByteIdentity");
        PRIMITIVE_IDENTITY_MAP.put("Byte", "javax.jdo.identity.ByteIdentity");
        IDENTITY_TYPES = new ArrayList();
        IDENTITY_TYPES.add("application");
        IDENTITY_TYPES.add("datastore");
        IDENTITY_TYPES.add("nondurable");
        VALUE_STRATEGY_LIST = new ArrayList();
        VALUE_STRATEGY_LIST.add("native");
        VALUE_STRATEGY_LIST.add("sequence");
        VALUE_STRATEGY_LIST.add("identity");
        VALUE_STRATEGY_LIST.add("increment");
        VALUE_STRATEGY_LIST.add("uuid-string");
        VALUE_STRATEGY_LIST.add("uuid-hex");
        VALUE_STRATEGY_LIST.add("datastore-uuid-hex");
        VALUE_STRATEGY_LIST.add("max");
        VALUE_STRATEGY_LIST.add("auid");
    }
}

