/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.snakeyaml;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.snakeyaml.AbstractSnakeYamlGenerator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;

@Named(value="snakeyaml-writer")
public class SnakeYamlWriterGenerator
extends AbstractSnakeYamlGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateSnakeYamlWriter();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating SnakeYaml Writer.", (Throwable)ex);
        }
    }

    private void generateSnakeYamlWriter() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.snakeyaml";
        String marshallerName = this.getFileName("SnakeYamlWriter");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        jClass.addImport("org.yaml.snakeyaml.DumperOptions");
        jClass.addImport("org.yaml.snakeyaml.DumperOptions.Version");
        jClass.addImport("org.yaml.snakeyaml.DumperOptions.FlowStyle");
        jClass.addImport("org.yaml.snakeyaml.DumperOptions.ScalarStyle");
        jClass.addImport("org.yaml.snakeyaml.emitter.Emitable");
        jClass.addImport("org.yaml.snakeyaml.emitter.Emitter");
        jClass.addImport("org.yaml.snakeyaml.error.Mark");
        jClass.addImport("org.yaml.snakeyaml.events.DocumentEndEvent");
        jClass.addImport("org.yaml.snakeyaml.events.DocumentStartEvent");
        jClass.addImport("org.yaml.snakeyaml.events.ImplicitTuple");
        jClass.addImport("org.yaml.snakeyaml.events.MappingEndEvent");
        jClass.addImport("org.yaml.snakeyaml.events.MappingStartEvent");
        jClass.addImport("org.yaml.snakeyaml.events.ScalarEvent");
        jClass.addImport("org.yaml.snakeyaml.events.SequenceEndEvent");
        jClass.addImport("org.yaml.snakeyaml.events.SequenceStartEvent");
        jClass.addImport("org.yaml.snakeyaml.events.StreamEndEvent");
        jClass.addImport("org.yaml.snakeyaml.events.StreamStartEvent");
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.OutputStream");
        jClass.addImport("java.io.OutputStreamWriter");
        jClass.addImport("java.io.Writer");
        this.addModelImports(jClass, null);
        JField factoryField = new JField((JType)new JClass("DumperOptions"), "dumperOptions");
        factoryField.getModifiers().setFinal(true);
        factoryField.setInitString("new DumperOptions()");
        jClass.addField(factoryField);
        JConstructor jacksonWriterConstructor = new JConstructor(jClass);
        JSourceCode sc = jacksonWriterConstructor.getSourceCode();
        sc.add("dumperOptions.setAllowUnicode( true );");
        sc.add("dumperOptions.setPrettyFlow( true );");
        sc.add("dumperOptions.setVersion( Version.V1_1 );");
        jClass.addConstructor(jacksonWriterConstructor);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        JMethod marshall = new JMethod("write");
        String rootElementParameterName = SnakeYamlWriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("IOException"));
        sc = marshall.getSourceCode();
        sc.add("Emitable generator = new Emitter( writer, dumperOptions );");
        sc.add("generator.emit( new StreamStartEvent( null, null ) );");
        sc.add("generator.emit( new DocumentStartEvent( null, null, dumperOptions.isExplicitStart(), dumperOptions.getVersion(), dumperOptions.getTags() ) );");
        sc.add("write" + root + "( " + rootElementParameterName + ", generator );");
        sc.add("generator.emit( new DocumentEndEvent( null, null, dumperOptions.isExplicitEnd() ) );");
        sc.add("generator.emit( new StreamEndEvent( null, null ) );");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("OutputStream"), "stream"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("IOException"));
        sc = marshall.getSourceCode();
        sc.add("write( new OutputStreamWriter( stream, " + rootElementParameterName + ".getModelEncoding() ), " + rootElementParameterName + " );");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        for (ModelClass clazz : this.getClasses(objectModel)) {
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String className = modelClass.getName();
        String uncapClassName = SnakeYamlWriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("Emitable"), "generator"));
        marshall.addException(new JClass("IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("generator.emit( new MappingStartEvent( null, null, true, null, null, FlowStyle.BLOCK ) );");
        ModelField contentField = null;
        String contentValue = null;
        List modelFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isContent()) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!xmlFieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            this.writeScalarKey(sc, fieldTagName);
            this.writeScalar(sc, this.getValue(field.getType(), value, xmlFieldMetadata));
            sc.unindent();
            sc.add("}");
        }
        if (contentField != null) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            this.writeScalar(sc, this.getValue(contentField.getType(), contentValue, xmlFieldMetadata));
        }
        boolean useJava5 = this.hasJavaSourceSupport(5);
        for (ModelField field : modelFields) {
            XmlFieldMetadata xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent()) continue;
            JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            String fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                if (association.isOneMultiplicity()) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    this.writeScalarKey(sc, fieldTagName);
                    sc.add("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", generator );");
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                type = association.getType();
                String toType = association.getTo();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    this.writeScalarKey(sc, fieldTagName);
                    sc.add("generator.emit( new SequenceStartEvent( null, null, true, null, null, false ) );");
                    if (useJava5) {
                        sc.add("for ( " + toType + " o : " + value + " )");
                    } else {
                        sc.add("for ( java.util.Iterator it = " + value + ".iterator(); it.hasNext(); )");
                    }
                    sc.add("{");
                    sc.indent();
                    if (!useJava5) {
                        sc.add(toType + " o = (" + toType + " ) it.next();");
                    }
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add("write" + toType + "( o, generator );");
                    } else {
                        this.writeScalar(sc, "o");
                    }
                    sc.unindent();
                    sc.add("}");
                    sc.add("generator.emit( new SequenceEndEvent( null, null ) );");
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                this.writeScalarKey(sc, fieldTagName);
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.emit( new SequenceStartEvent( null, null, true, null, null, false ) );");
                } else {
                    sc.add("generator.emit( new MappingStartEvent( null, null, true, null, null, FlowStyle.BLOCK ) );");
                }
                StringBuilder entryTypeBuilder = new StringBuilder("java.util.Map.Entry");
                if (useJava5) {
                    entryTypeBuilder.append('<');
                    if (association.getType().equals("java.util.Properties")) {
                        entryTypeBuilder.append("Object, Object");
                    } else {
                        entryTypeBuilder.append("String, ").append(association.getTo());
                    }
                    entryTypeBuilder.append('>');
                }
                if (useJava5) {
                    sc.add("for ( " + entryTypeBuilder + " entry : " + value + ".entrySet() )");
                } else {
                    sc.add("for ( java.util.Iterator it = " + value + ".entrySet().iterator(); it.hasNext(); )");
                }
                sc.add("{");
                sc.indent();
                if (!useJava5) {
                    sc.add(entryTypeBuilder + " entry = (" + entryTypeBuilder + ") it.next();");
                }
                sc.add("final String key = String.valueOf( entry.getKey() );");
                sc.add("final String value = String.valueOf( entry.getValue() );");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.emit( new MappingStartEvent( null, null, true, null, null, FlowStyle.BLOCK) );");
                    this.writeScalarKey(sc, "key");
                    this.writeScalar(sc, "key");
                    this.writeScalarKey(sc, "value");
                    this.writeScalar(sc, "value");
                    sc.add("generator.emit( new MappingEndEvent( null, null ) );");
                } else {
                    this.writeScalar(sc, "key");
                    this.writeScalar(sc, "value");
                }
                sc.unindent();
                sc.add("}");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("generator.emit( new SequenceEndEvent( null, null ) );");
                } else {
                    sc.add("generator.emit( new MappingEndEvent( null, null ) );");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            this.writeScalarKey(sc, fieldTagName);
            this.writeScalar(sc, this.getValue(field.getType(), value, xmlFieldMetadata));
            sc.unindent();
            sc.add("}");
        }
        sc.add("generator.emit( new MappingEndEvent( null, null ) );");
        jClass.addMethod(marshall);
    }

    private void writeScalarKey(JSourceCode sc, String key) {
        this.writeScalar(sc, "\"" + key + "\"");
    }

    private void writeScalar(JSourceCode sc, String value) {
        sc.add("{");
        sc.indent();
        sc.add("String anchor = null, tag = null;");
        sc.add("Mark startMark = null, endMark = null;");
        sc.add("ScalarStyle style = ScalarStyle.DOUBLE_QUOTED;");
        sc.add("generator.emit( new ScalarEvent( anchor, tag, new ImplicitTuple( true, true ), " + value + ", startMark, endMark, style ) );");
        sc.unindent();
        sc.add("}");
    }
}

