/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.xpp3.AbstractXpp3Generator;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;

@Named(value="xpp3-writer")
public class Xpp3WriterGenerator
extends AbstractXpp3Generator {
    private String extendedClassnameSuffix;

    protected void prepareLocationTracking(JClass jClass) {
    }

    protected void writeLocationTracking(JSourceCode sc, String name, String key) {
        if (this.isLocationTracking()) {
            sc.add("writeLocationTracking( " + name + ", " + key + ", serializer );");
        }
    }

    @Override
    protected void initialize(Model model, Properties parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.extendedClassnameSuffix = "Ex";
        if (this.isLocationTracking()) {
            this.extendedClassnameSuffix = parameters.getProperty("modello.xpp3.extended.suffix");
        }
    }

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXpp3Writer();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XPP3 Writer.", (Throwable)ex);
        }
    }

    private void generateXpp3Writer() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = objectModel.getDefaultPackageName(this.isPackageWithVersion(), this.getGeneratedVersion()) + ".io.xpp3";
        String marshallerName = this.getFileName("Xpp3Writer" + (this.isLocationTracking() ? this.extendedClassnameSuffix : ""));
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(packageName + '.' + marshallerName);
        this.initHeader(jClass);
        this.suppressAllWarnings(objectModel, (JStructure)jClass);
        jClass.addImport("org.codehaus.plexus.util.xml.pull.XmlSerializer");
        jClass.addImport("org.codehaus.plexus.util.xml.pull.MXSerializer");
        jClass.addImport("java.io.OutputStream");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.util.Iterator");
        JField namespaceField = new JField((JType)new JClass("String"), "NAMESPACE");
        namespaceField.getModifiers().setFinal(true);
        namespaceField.getModifiers().setStatic(true);
        namespaceField.setInitString("null");
        jClass.addField(namespaceField);
        JField commentField = new JField((JType)new JClass("String"), "fileComment");
        commentField.setInitString("null");
        jClass.addField(commentField);
        JMethod setComment = new JMethod("setFileComment");
        setComment.addParameter(new JParameter((JType)new JClass("String"), "fileComment"));
        JSourceCode setCommentSourceCode = setComment.getSourceCode();
        setCommentSourceCode.add("this.fileComment = fileComment;");
        jClass.addMethod(setComment);
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        String rootElement = this.resolveTagName(rootClass);
        JMethod marshall = new JMethod("write");
        String rootElementParameterName = Xpp3WriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("XmlSerializer serializer = new MXSerializer();");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-indentation\", \"  \" );");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-line-separator\", \"\\n\" );");
        sc.add("serializer.setOutput( writer );");
        sc.add("serializer.startDocument( " + rootElementParameterName + ".getModelEncoding(), null );");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", serializer );");
        sc.add("serializer.endDocument();");
        jClass.addMethod(marshall);
        marshall = new JMethod("write");
        marshall.addParameter(new JParameter((JType)new JClass("OutputStream"), "stream"));
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("java.io.IOException"));
        sc = marshall.getSourceCode();
        sc.add("XmlSerializer serializer = new MXSerializer();");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-indentation\", \"  \" );");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-line-separator\", \"\\n\" );");
        sc.add("serializer.setOutput( stream, " + rootElementParameterName + ".getModelEncoding() );");
        sc.add("serializer.startDocument( " + rootElementParameterName + ".getModelEncoding(), null );");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", serializer );");
        sc.add("serializer.endDocument();");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        if (this.isLocationTracking()) {
            this.prepareLocationTracking(jClass);
        }
        if (this.requiresDomSupport) {
            this.createWriteDomMethod(jClass);
        }
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) throws ModelloException {
        for (ModelClass clazz : this.getClasses(objectModel)) {
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) throws ModelloException {
        String value;
        String type;
        String fieldTagName;
        JavaFieldMetadata javaFieldMetadata;
        XmlFieldMetadata xmlFieldMetadata;
        String className = modelClass.getName();
        String uncapClassName = Xpp3WriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod("write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        marshall.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        marshall.addException(new JClass("java.io.IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        ModelClassMetadata classMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        String namespace = null;
        XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)modelClass.getModel().getMetadata(XmlModelMetadata.ID);
        if (classMetadata.isRootElement() && xmlModelMetadata.getNamespace() != null) {
            sc.add("if ( this.fileComment != null )");
            sc.add("{");
            sc.add("serializer.comment(this.fileComment);");
            sc.add("}");
            namespace = xmlModelMetadata.getNamespace(this.getGeneratedVersion());
            sc.add("serializer.setPrefix( \"\", \"" + namespace + "\" );");
        }
        if (namespace != null && xmlModelMetadata.getSchemaLocation() != null) {
            String url = xmlModelMetadata.getSchemaLocation(this.getGeneratedVersion());
            sc.add("serializer.setPrefix( \"xsi\", \"http://www.w3.org/2001/XMLSchema-instance\" );");
            sc.add("serializer.startTag( NAMESPACE, tagName );");
            sc.add("serializer.attribute( \"\", \"xsi:schemaLocation\", \"" + namespace + " " + url + "\" );");
        } else {
            sc.add("serializer.startTag( NAMESPACE, tagName );");
        }
        ModelField contentField = null;
        String contentValue = null;
        List modelFields = this.getFieldsForXml(modelClass, this.getGeneratedVersion());
        for (ModelField field : modelFields) {
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isContent()) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!xmlFieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.addIndented("serializer.attribute( NAMESPACE, \"" + fieldTagName + "\", " + this.getValue(field.getType(), value, xmlFieldMetadata) + " );");
            sc.add("}");
        }
        if (contentField != null) {
            XmlFieldMetadata xmlFieldMetadata2 = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            sc.add("serializer.text( " + this.getValue(contentField.getType(), contentValue, xmlFieldMetadata2) + " );");
        }
        for (ModelField field : modelFields) {
            xmlFieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (xmlFieldMetadata.isContent()) continue;
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = this.resolveTagName(field, xmlFieldMetadata);
            type = field.getType();
            value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (xmlFieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                String associationName = association.getName();
                if (association.isOneMultiplicity()) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.addIndented("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", \"" + fieldTagName + "\", serializer );");
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                String valuesTagName = this.resolveTagName(fieldTagName, xmlAssociationMetadata);
                type = association.getType();
                String toType = association.getTo();
                boolean wrappedItems = xmlAssociationMetadata.isWrappedItems();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    boolean isList = "java.util.List".equals(type);
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (wrappedItems) {
                        sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    if (this.isLocationTracking() && !this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(this.locationTracker.getName() + " location = " + uncapClassName + ".getLocation( \"" + fieldTagName + "\" );");
                        if (isList) {
                            sc.add("int n = 0;");
                        }
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + valuesTagName + "\", serializer );");
                    } else {
                        String variable = Xpp3WriterGenerator.singular((String)Xpp3WriterGenerator.uncapitalise((String)field.getName()));
                        sc.add(toType + " " + variable + " = (" + toType + ") iter.next();");
                        sc.add("serializer.startTag( NAMESPACE, \"" + valuesTagName + "\" ).text( " + variable + " ).endTag( NAMESPACE, \"" + valuesTagName + "\" );");
                        this.writeLocationTracking(sc, "location", isList ? "Integer.valueOf( n++ )" : variable);
                    }
                    sc.unindent();
                    sc.add("}");
                    if (wrappedItems) {
                        sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (wrappedItems) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                if (this.isLocationTracking()) {
                    sc.add(this.locationTracker.getName() + " location = " + uncapClassName + ".getLocation( \"" + fieldTagName + "\" );");
                }
                sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                sc.add("{");
                sc.indent();
                sc.add("String key = (String) iter.next();");
                sc.add("String value = (String) " + value + ".get( key );");
                if (xmlAssociationMetadata.isMapExplode()) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + Xpp3WriterGenerator.singular((String)associationName) + "\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"key\" ).text( key ).endTag( NAMESPACE, \"key\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"value\" ).text( value ).endTag( NAMESPACE, \"value\" );");
                    sc.add("serializer.endTag( NAMESPACE, \"" + Xpp3WriterGenerator.singular((String)associationName) + "\" );");
                } else {
                    sc.add("serializer.startTag( NAMESPACE, key ).text( value ).endTag( NAMESPACE, key );");
                }
                this.writeLocationTracking(sc, "location", "key");
                sc.unindent();
                sc.add("}");
                if (wrappedItems) {
                    sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            if ("DOM".equals(field.getType())) {
                if (this.domAsXpp3) {
                    jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
                    if (this.isLocationTracking()) {
                        sc.addIndented("writeXpp3DomToSerializer( (Xpp3Dom) " + value + ", serializer );");
                    } else {
                        sc.addIndented("((Xpp3Dom) " + value + ").writeToSerializer( NAMESPACE, serializer );");
                    }
                } else {
                    sc.addIndented("writeDom( (org.w3c.dom.Element) " + value + ", serializer );");
                }
                this.requiresDomSupport = true;
            } else {
                sc.addIndented("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" ).text( " + this.getValue(field.getType(), value, xmlFieldMetadata) + " ).endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                sc.indent();
                this.writeLocationTracking(sc, uncapClassName, '\"' + fieldTagName + '\"');
                sc.unindent();
            }
            sc.add("}");
        }
        sc.add("serializer.endTag( NAMESPACE, tagName );");
        jClass.addMethod(marshall);
    }

    private void createWriteDomMethod(JClass jClass) {
        if (this.domAsXpp3) {
            return;
        }
        String type = "org.w3c.dom.Element";
        JMethod method = new JMethod("writeDom");
        method.getModifiers().makePrivate();
        method.addParameter(new JParameter(new JType(type), "dom"));
        method.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        method.addException(new JClass("java.io.IOException"));
        JSourceCode sc = method.getSourceCode();
        sc.add("serializer.startTag( NAMESPACE, dom.getTagName() );");
        sc.add("org.w3c.dom.NamedNodeMap attributes = dom.getAttributes();");
        sc.add("for ( int i = 0; i < attributes.getLength(); i++ )");
        sc.add("{");
        sc.indent();
        sc.add("org.w3c.dom.Node attribute = attributes.item( i );");
        sc.add("serializer.attribute( NAMESPACE, attribute.getNodeName(), attribute.getNodeValue() );");
        sc.unindent();
        sc.add("}");
        sc.add("org.w3c.dom.NodeList children = dom.getChildNodes();");
        sc.add("for ( int i = 0; i < children.getLength(); i++ )");
        sc.add("{");
        sc.indent();
        sc.add("org.w3c.dom.Node node = children.item( i );");
        sc.add("if ( node instanceof org.w3c.dom.Element)");
        sc.add("{");
        sc.addIndented("writeDom( (org.w3c.dom.Element) children.item( i ), serializer );");
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.addIndented("serializer.text( node.getTextContent() );");
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("serializer.endTag( NAMESPACE, dom.getTagName() );");
        jClass.addMethod(method);
    }
}

