/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.castor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.castor.CastorSourceGenerator;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMojo
extends AbstractMojo {
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private static final String DEFAULT_PROPERTY_FILE_LOCATION = "src/main/castor/castorbuilder.properties";
    private File bindingfile;
    private File schema;
    private File schemaDirectory;
    private File dest;
    private File tstamp;
    private int staleMillis = 0;
    private String types = "arraylist";
    private boolean descriptors = true;
    private boolean verbose = false;
    private boolean warnings = false;
    private boolean marshal = true;
    private String lineSeparator;
    private File properties;
    private String packaging;
    private boolean generateImportedSchemas = false;
    private boolean generateMappings = false;
    private String classGenerationMode = "standard";
    private File resourceDestination;
    private boolean createJdoDescriptors = false;
    private MavenProject project;
    private CastorSourceGenerator sgen;

    public void execute() throws MojoExecutionException {
        Set<File> staleXSDs;
        if (!this.dest.exists()) {
            FileUtils.mkdir((String)this.dest.getAbsolutePath());
        }
        if (!this.resourceDestination.exists()) {
            FileUtils.mkdir((String)this.resourceDestination.getAbsolutePath());
        }
        if ((staleXSDs = this.computeStaleXSDs()).isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all xsds are up to date");
            this.project.addCompileSourceRoot(this.dest.getAbsolutePath());
            this.getLog().info((CharSequence)("Adding resource " + this.getResourceDestination().getAbsolutePath() + " ... "));
            Resource resource = new Resource();
            resource.setDirectory(this.getResourceDestination().getAbsolutePath());
            resource.addInclude("**/*.cdr");
            resource.addExclude("**/*.java");
            this.project.addResource(resource);
            return;
        }
        this.config();
        for (File xsd : staleXSDs) {
            try {
                this.processFile(xsd.getCanonicalPath());
                File timeStampDir = this.getTimeStampDirectory();
                FileUtils.copyFileToDirectory((File)xsd, (File)timeStampDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Castor execution failed", e);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Castor execution failed", t);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.dest.getAbsolutePath());
            this.getLog().info((CharSequence)("Adding resource " + this.getResourceDestination().getAbsolutePath() + " ... "));
            Resource resource = new Resource();
            resource.setDirectory(this.getResourceDestination().getAbsolutePath());
            resource.addInclude("**/*.cdr");
            resource.addExclude("**/*.java");
            this.project.addResource(resource);
        }
    }

    private Set<File> computeStaleXSDs() throws MojoExecutionException {
        HashSet<File> staleSources = new HashSet<File>();
        if (this.schema != null && this.schema.exists()) {
            File sourceFile = this.schema;
            File targetFile = new File(this.getTimeStampDirectory(), sourceFile.getName());
            if (!targetFile.exists() || targetFile.lastModified() + (long)this.staleMillis < sourceFile.lastModified()) {
                this.getLog().debug((CharSequence)("Finding XSDs - adding schema " + targetFile));
                staleSources.add(sourceFile);
            } else {
                this.getLog().debug((CharSequence)("Finding XSDs - adding schema " + targetFile));
            }
        } else {
            SuffixMapping mapping = new SuffixMapping(".xsd", ".xsd");
            File tstampDir = this.getTimeStampDirectory();
            File schemaDir = this.schemaDirectory;
            SourceInclusionScanner scanner = this.getSourceInclusionScanner();
            scanner.addSourceMapping((SourceMapping)mapping);
            try {
                this.getLog().debug((CharSequence)("Finding XSDs - adding scanned XSDs from schemaDir " + schemaDir + " tstampDir " + tstampDir));
                staleSources.addAll(scanner.getIncludedSources(schemaDir, tstampDir));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + schemaDir + "' for stale xsds to reprocess.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    private SourceInclusionScanner getSourceInclusionScanner() {
        return new StaleSourceScanner((long)this.staleMillis);
    }

    private File getTimeStampDirectory() {
        return this.tstamp;
    }

    private void config() throws MojoExecutionException {
        this.sgen = CastorSourceGenerator.createSourceGenerator(this.types);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Successfully created an instance of the Castor XML source generator, release 1.3.0.1");
        }
        this.sgen.setLog(this.getLog());
        this.sgen.setLineSeparatorStyle(this.lineSeparator);
        this.sgen.setDestDir(this.dest.getAbsolutePath());
        this.callSetterMethodUsingReflection("setResourceDestination", String.class, this.getResourceDestination().getAbsolutePath());
        if (this.bindingfile != null && this.bindingfile.exists()) {
            this.sgen.setBindingFile(this.bindingfile);
        }
        this.sgen.setVerbose(this.verbose);
        this.sgen.setSuppressNonFatalWarnings(!this.warnings);
        this.sgen.setDescriptorCreation(this.descriptors);
        if (!this.descriptors) {
            this.log(DISABLE_DESCRIPTORS_MSG);
        }
        this.sgen.setCreateMarshalMethods(this.marshal);
        if (!this.marshal) {
            this.log(DISABLE_MARSHALL_MSG);
        }
        if (this.properties != null && this.properties.exists()) {
            this.sgen.setBuilderProperties(this.properties);
        } else {
            File defaultPropertyFile = new File(this.getProject().getBasedir(), DEFAULT_PROPERTY_FILE_LOCATION);
            if (this.properties != null && !this.properties.equals(defaultPropertyFile)) {
                this.getLog().warn((CharSequence)("Cannot find custom builder property file " + this.properties.getAbsolutePath()));
                throw new MojoExecutionException("Cannot find custom builder property file " + this.properties.getAbsolutePath());
            }
            if (this.properties != null) {
                this.getLog().info((CharSequence)("There is no custom builder property file at the default location at " + this.properties.getAbsolutePath() + ". Continuing code generation without."));
            }
        }
        if (this.createJdoDescriptors) {
            this.callSetterMethodUsingReflection("setJdoDescriptorCreation", Boolean.TYPE, new Boolean(this.createJdoDescriptors));
        }
        if (this.isGenerateImportedSchemas()) {
            this.sgen.setGenerateImportedSchemas(true);
        }
        if (this.generateMapping()) {
            this.sgen.setGenerateMappingFile(this.generateMappings);
            this.sgen.setDescriptorCreation(false);
        }
        if (!this.getClassGenerationMode().equals("standard")) {
            this.callSetterMethodUsingReflection("setJClassPrinterType", String.class, this.getClassGenerationMode());
        }
    }

    private void callSetterMethodUsingReflection(String methodName, Class<?> parameterType, Object parameterValue) throws MojoExecutionException {
        this.getLog().info((CharSequence)("About to invoke method >" + methodName + "< on Castor's SourceGenerator class using reflection."));
        try {
            Method method = ((Object)((Object)this.sgen)).getClass().getMethod(methodName, parameterType);
            method.invoke((Object)this.sgen, parameterValue);
        }
        catch (NoSuchMethodException e) {
            this.getLog().info((CharSequence)("Specified method " + methodName + " not available on class SourceGenerator."));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Problem calling SourceGenerator." + methodName + ": ", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Problem calling SourceGenerator." + methodName + ": ", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Problem calling SourceGenerator." + methodName + ": ", (Exception)e);
        }
    }

    private void processFile(String filePath) throws MojoExecutionException {
        this.log("Processing " + filePath);
        try {
            this.sgen.generateSource(filePath, this.packaging);
        }
        catch (FileNotFoundException e) {
            String message = "XML Schema file \"" + filePath + "\" not found.";
            this.log(message);
            throw new MojoExecutionException(message);
        }
        catch (IOException iox) {
            throw new MojoExecutionException("An IOException occurred processing " + filePath, (Exception)iox);
        }
        catch (Exception e) {
            throw new MojoExecutionException("An Exception occurred processing " + filePath, e);
        }
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    public File getDest() {
        return this.dest;
    }

    public File getResourceDestination() {
        return this.resourceDestination;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setResourceDestination(File resourceDestination) {
        this.resourceDestination = resourceDestination;
    }

    public File getTstamp() {
        return this.tstamp;
    }

    public void setTstamp(File tstamp) {
        this.tstamp = tstamp;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public File getSchema() {
        return this.schema;
    }

    public void setSchema(File schema) {
        this.schema = schema;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public void setBindingfile(File bindingfile) {
        this.bindingfile = bindingfile;
    }

    public void setProperties(File properties) {
        this.properties = properties;
    }

    public boolean getMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public boolean isGenerateImportedSchemas() {
        return this.generateImportedSchemas;
    }

    public void setGenerateImportedSchemas(boolean generateImportedSchemas) {
        this.generateImportedSchemas = generateImportedSchemas;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public final boolean getCreateJdoDescriptors() {
        return this.createJdoDescriptors;
    }

    public final void setCreateJdoDescriptors(boolean newCreateJdoDescriptors) {
        this.createJdoDescriptors = newCreateJdoDescriptors;
    }

    private boolean generateMapping() {
        return this.generateMappings;
    }

    public final void setGenerateMappings(boolean generateMappings) {
        this.generateMappings = generateMappings;
    }

    public String getClassGenerationMode() {
        return this.classGenerationMode;
    }

    public void setClassGenerationMode(String classPrinterMethod) {
        this.classGenerationMode = classPrinterMethod;
    }
}

