/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.mojo.exec.PathsToolchain;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ToolchainFactory.class, hint="paths")
class PathsToolchainFactory
implements ToolchainFactory {
    @Requirement
    private Logger logger;

    PathsToolchainFactory() {
    }

    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        if (model == null) {
            return null;
        }
        PathsToolchain pathsToolchain = new PathsToolchain(model, this.logger);
        Properties provides = this.getProvidesProperties(model);
        for (Map.Entry<Object, Object> provide : provides.entrySet()) {
            String key = (String)provide.getKey();
            String value = (String)provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            pathsToolchain.addProvideToken(key, RequirementMatcherFactory.createExactMatcher((String)value));
        }
        Xpp3Dom config = (Xpp3Dom)model.getConfiguration();
        if (config == null) {
            return pathsToolchain;
        }
        Xpp3Dom pathDom = config.getChild("paths");
        if (pathDom == null) {
            return pathsToolchain;
        }
        Xpp3Dom[] pathDoms = pathDom.getChildren("path");
        if (pathDoms == null || pathDoms.length == 0) {
            return pathsToolchain;
        }
        ArrayList<String> paths = new ArrayList<String>(pathDoms.length);
        for (Xpp3Dom pathdom : pathDoms) {
            String pathString = pathdom.getValue();
            if (pathString == null) {
                throw new MisconfiguredToolchainException("path element is empty");
            }
            String normalizedPath = FileUtils.normalize((String)pathString);
            File file = new File(normalizedPath);
            if (!file.exists()) {
                throw new MisconfiguredToolchainException("Non-existing path '" + file.getAbsolutePath() + "'");
            }
            paths.add(normalizedPath);
        }
        pathsToolchain.setPaths(paths);
        return pathsToolchain;
    }

    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected Properties getProvidesProperties(ToolchainModel model) {
        Object value = this.getBeanProperty(model, "provides");
        return value instanceof Properties ? (Properties)value : PathsToolchainFactory.toProperties((Xpp3Dom)value);
    }

    protected static Properties toProperties(Xpp3Dom dom) {
        Xpp3Dom[] children;
        Properties props = new Properties();
        for (Xpp3Dom child : children = dom.getChildren()) {
            props.put(child.getName(), child.getValue());
        }
        return props;
    }

    protected Object getBeanProperty(Object obj, String property) {
        try {
            Method method = new PropertyDescriptor(property, obj.getClass()).getReadMethod();
            return method.invoke(obj, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException e) {
            throw new RuntimeException("Incompatible toolchain API", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Incompatible toolchain API", e);
        }
    }
}

