/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SortableLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.ClassLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.MethodLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.PackageLocation;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.Validate;

public class JavaDocExtractor {
    private JavaProjectBuilder builder;
    private Log log;

    public JavaDocExtractor(Log log) {
        Validate.notNull(log, "log");
        this.log = log;
        this.builder = new JavaProjectBuilder();
    }

    public void setEncoding(String encoding) {
        this.builder.setEncoding(encoding);
    }

    public JavaDocExtractor addSourceFiles(List<File> sourceCodeFiles) throws IllegalArgumentException {
        Validate.notNull(sourceCodeFiles, "addSourceFiles");
        for (File current : sourceCodeFiles) {
            try {
                this.builder.addSource(current);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not add file [" + FileSystemUtilities.getCanonicalPath(current) + "]", e);
            }
        }
        return this;
    }

    public JavaDocExtractor addSourceURLs(List<URL> sourceCodeURLs) throws IllegalArgumentException {
        Validate.notNull(sourceCodeURLs, "sourceCodeURLs");
        for (URL current : sourceCodeURLs) {
            try {
                this.builder.addSource(current);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not add URL [" + current.toString() + "]", e);
            }
        }
        return this;
    }

    public SearchableDocumentation process() {
        TreeMap<SortableLocation, JavaDocData> dataHolder = new TreeMap<SortableLocation, JavaDocData>();
        Collection sources = this.builder.getSources();
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Processing [" + sources.size() + "] java sources."));
        }
        for (JavaSource current : sources) {
            JavaPackage currentPackage = current.getPackage();
            String packageName = currentPackage.getName();
            this.addEntry(dataHolder, new PackageLocation(packageName), (JavaAnnotatedElement)currentPackage);
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Added package-level JavaDoc for [" + packageName + "]"));
            }
            for (JavaClass currentClass : current.getClasses()) {
                String annotatedXmlName;
                String simpleClassName = currentClass.getName();
                String classXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlType.class, "name", currentClass.getAnnotations());
                ClassLocation classLocation = new ClassLocation(packageName, simpleClassName, classXmlName);
                this.addEntry(dataHolder, classLocation, (JavaAnnotatedElement)currentClass);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Added class-level JavaDoc for [" + classLocation + "]"));
                }
                for (JavaField currentField : currentClass.getFields()) {
                    annotatedXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlElement.class, "name", currentField.getAnnotations());
                    if (annotatedXmlName == null) {
                        annotatedXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlAttribute.class, "name", currentField.getAnnotations());
                    }
                    if (annotatedXmlName == null) {
                        annotatedXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlEnumValue.class, "value", currentField.getAnnotations());
                    }
                    FieldLocation fieldLocation = new FieldLocation(packageName, simpleClassName, classXmlName, currentField.getName(), annotatedXmlName);
                    this.addEntry(dataHolder, fieldLocation, (JavaAnnotatedElement)currentField);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((CharSequence)("Added field-level JavaDoc for [" + fieldLocation + "]"));
                }
                for (JavaMethod currentMethod : currentClass.getMethods()) {
                    annotatedXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlElement.class, "name", currentMethod.getAnnotations());
                    if (annotatedXmlName == null) {
                        annotatedXmlName = JavaDocExtractor.getAnnotationAttributeValuleFrom(XmlAttribute.class, "name", currentMethod.getAnnotations());
                    }
                    MethodLocation location = new MethodLocation(packageName, simpleClassName, classXmlName, currentMethod.getName(), annotatedXmlName, currentMethod.getParameters());
                    this.addEntry(dataHolder, location, (JavaAnnotatedElement)currentMethod);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((CharSequence)("Added method-level JavaDoc for [" + location + "]"));
                }
            }
        }
        return new ReadOnlySearchableDocumentation(dataHolder);
    }

    private static String getAnnotationAttributeValuleFrom(Class<?> annotationType, String attributeName, List<JavaAnnotation> annotations) {
        String fullyQualifiedClassName = annotationType.getName();
        JavaAnnotation annotation = null;
        String toReturn = null;
        if (annotations != null) {
            Object nameValue;
            for (JavaAnnotation current : annotations) {
                if (!current.getType().isA(fullyQualifiedClassName)) continue;
                annotation = current;
                break;
            }
            if (annotation != null && (nameValue = annotation.getNamedParameter(attributeName)) != null && nameValue instanceof String && (toReturn = ((String)nameValue).trim()).startsWith("\"") && toReturn.endsWith("\"")) {
                toReturn = ((String)nameValue).trim().substring(1, toReturn.length() - 1);
            }
        }
        return toReturn;
    }

    private void addEntry(SortedMap<SortableLocation, JavaDocData> map, SortableLocation key, JavaAnnotatedElement value) {
        if (map.containsKey(key)) {
            JavaDocData existing = (JavaDocData)map.get(key);
            if (key instanceof PackageLocation) {
                boolean emptyGiven;
                boolean emptyExisting = existing.getComment() == null || existing.getComment().isEmpty();
                boolean bl = emptyGiven = value.getComment() == null || value.getComment().isEmpty();
                if (emptyGiven) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)("Skipping processing empty Package javadoc from [" + key + "]"));
                    }
                    return;
                }
                if (emptyExisting && this.log.isWarnEnabled()) {
                    this.log.warn((CharSequence)("Overwriting empty Package javadoc from [" + key + "]"));
                }
            } else {
                String given = "[" + value.getClass().getName() + "]: " + value.getComment();
                throw new IllegalArgumentException("Not processing duplicate SortableLocation [" + key + "]. " + "\n Existing: " + existing + ".\n Given: [" + given + "]");
            }
        }
        map.put(key, new JavaDocData(value.getComment(), value.getTags()));
    }

    private class ReadOnlySearchableDocumentation
    implements SearchableDocumentation {
        private TreeMap<String, SortableLocation> keyMap;
        private SortedMap<? extends SortableLocation, JavaDocData> valueMap;

        ReadOnlySearchableDocumentation(SortedMap<SortableLocation, JavaDocData> valueMap) {
            this.valueMap = valueMap;
            this.keyMap = new TreeMap();
            for (Map.Entry<SortableLocation, JavaDocData> current : valueMap.entrySet()) {
                SortableLocation key = current.getKey();
                this.keyMap.put(key.getPath(), key);
            }
        }

        @Override
        public SortedSet<String> getPaths() {
            return Collections.unmodifiableSortedSet(this.keyMap.navigableKeySet());
        }

        @Override
        public JavaDocData getJavaDoc(String path) {
            Validate.notNull(path, "path");
            Object location = this.getLocation(path);
            return location == null ? null : (JavaDocData)this.valueMap.get(location);
        }

        @Override
        public <T extends SortableLocation> T getLocation(String path) {
            Validate.notNull(path, "path");
            return (T)this.keyMap.get(path);
        }

        @Override
        public SortedMap<SortableLocation, JavaDocData> getAll() {
            return Collections.unmodifiableSortedMap(this.valueMap);
        }

        @Override
        public <T extends SortableLocation> SortedMap<T, JavaDocData> getAll(Class<T> type) {
            Validate.notNull(type, "type");
            TreeMap<SortableLocation, JavaDocData> toReturn = new TreeMap<SortableLocation, JavaDocData>();
            for (Map.Entry<? extends SortableLocation, JavaDocData> current : this.valueMap.entrySet()) {
                if (type != current.getKey().getClass()) continue;
                toReturn.put(current.getKey(), current.getValue());
            }
            return toReturn;
        }
    }
}

