/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.filters.pattern;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.shared.FileSystemUtilities;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;
import org.codehaus.mojo.jaxb2.shared.filters.Filters;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.AbstractPatternFilter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.StringConverter;

public class PatternFileFilter
extends AbstractPatternFilter<File>
implements FileFilter {
    public static final String PATTERN_LETTER_DIGIT_PUNCT = "(\\p{javaLetterOrDigit}|\\p{Punct})+";
    public static final StringConverter<File> FILE_PATH_CONVERTER = new StringConverter<File>(){

        @Override
        public String convert(File toConvert) {
            return FileSystemUtilities.getCanonicalPath(toConvert.getAbsoluteFile());
        }
    };

    public PatternFileFilter(boolean processNullValues, String patternPrefix, List<String> patterns, StringConverter<File> converter, boolean acceptCandidateOnPatternMatch) {
        this.setProcessNullValues(processNullValues);
        this.setAcceptCandidateOnPatternMatch(acceptCandidateOnPatternMatch);
        this.setPatternPrefix(patternPrefix);
        this.setPatterns(patterns);
        this.setConverter(converter);
    }

    public PatternFileFilter(List<String> patternStrings, boolean acceptCandidateOnPatternMatch) {
        this(false, PATTERN_LETTER_DIGIT_PUNCT, patternStrings, FILE_PATH_CONVERTER, acceptCandidateOnPatternMatch);
    }

    public PatternFileFilter(List<String> patterns) {
        this(false, PATTERN_LETTER_DIGIT_PUNCT, patterns, FILE_PATH_CONVERTER, true);
    }

    public PatternFileFilter() {
        this(false, PATTERN_LETTER_DIGIT_PUNCT, new ArrayList<String>(), FILE_PATH_CONVERTER, true);
    }

    public static List<Filter<File>> createExcludeFilterList(Log log, String ... patterns) {
        return PatternFileFilter.createFilterList(log, false, patterns);
    }

    public static List<Filter<File>> createIncludeFilterList(Log log, String ... patterns) {
        return PatternFileFilter.createFilterList(log, true, patterns);
    }

    private static List<Filter<File>> createFilterList(Log log, boolean includeOperation, String ... patterns) {
        Validate.notNull(patterns, "patterns");
        Validate.notNull(log, "log");
        ArrayList<Filter<File>> toReturn = new ArrayList<Filter<File>>();
        List<String> patternStrings = Arrays.asList(patterns);
        toReturn.add(new PatternFileFilter(patternStrings, includeOperation));
        Filters.initialize(log, toReturn);
        return toReturn;
    }
}

