/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public abstract class AbstractDeployerMojo
extends AbstractMojo {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    protected int port;
    protected String hostName;
    protected List fileNames;
    private WagonManager wagonManager;
    private String server;

    protected void doURL(String url) throws MojoExecutionException {
        try {
            url = url.replaceAll("\\s", "%20");
            this.getLog().debug((CharSequence)("url = " + url));
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("Authorization", this.toAuthorization());
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Mojo error occurred: " + e.getMessage(), e);
        }
    }

    private String toAuthorization() throws MojoExecutionException {
        String password;
        String userName;
        if (this.server == null) {
            this.getLog().info((CharSequence)"No server specified for authentication - using defaults");
            userName = DEFAULT_USERNAME;
            password = DEFAULT_PASSWORD;
        } else {
            AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.server);
            if (info == null) {
                throw new MojoExecutionException("Server not defined in settings.xml: " + this.server);
            }
            userName = info.getUserName();
            if (userName == null) {
                this.getLog().info((CharSequence)"No server username specified - using default");
                userName = DEFAULT_USERNAME;
            }
            if ((password = info.getPassword()) == null) {
                this.getLog().info((CharSequence)"No server password specified - using default");
                password = DEFAULT_PASSWORD;
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(userName).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }
}

