/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractJBossMojo
extends AbstractMojo {
    protected String jbossHome;
    protected String serverName;

    protected void checkConfig() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Using JBOSS_HOME: " + this.jbossHome));
        if (this.jbossHome == null || this.jbossHome.equals("")) {
            throw new MojoExecutionException("Neither JBOSS_HOME nor the jbossHome configuration parameter is set!");
        }
    }

    protected void launch(String fName, String params) throws MojoExecutionException {
        try {
            this.checkConfig();
            String osName = System.getProperty("os.name");
            Runtime runtime = Runtime.getRuntime();
            Process p = null;
            if (osName.startsWith("Windows")) {
                String[] command = new String[]{"cmd.exe", "/C", "cd " + this.jbossHome + "\\bin & " + fName + ".bat " + " " + params};
                p = runtime.exec(command);
                this.dump(p.getInputStream());
                this.dump(p.getErrorStream());
            } else {
                String[] command = new String[]{"sh", "-c", "cd " + this.jbossHome + "/bin; ./" + fName + ".sh " + " " + params};
                p = runtime.exec(command);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Mojo error occurred: " + e.getMessage(), e);
        }
    }

    protected void dump(final InputStream input) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    byte[] b = new byte[1000];
                    while (input.read(b) != -1) {
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

