/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.AbstractDeployerMojo;

public class DeployMojo
extends AbstractDeployerMojo {
    protected String deployUrlPath;
    protected String fileNameEncoding;

    public void execute() throws MojoExecutionException {
        if (this.fileNames == null) {
            this.getLog().info((CharSequence)"No files configured to deploy.");
            return;
        }
        Iterator iter = this.fileNames.iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            String fixedFile = null;
            fixedFile = fileName.toLowerCase().endsWith("ejb") ? fileName.substring(0, fileName.length() - 3) + "jar" : fileName;
            try {
                String encoding = this.fileNameEncoding;
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                fixedFile = URLEncoder.encode(fixedFile, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new MojoExecutionException(ex.getMessage());
            }
            this.getLog().info((CharSequence)("Deploying " + fileName + " to JBoss."));
            String url = "http://" + this.hostName + ":" + this.port + this.deployUrlPath + fixedFile;
            this.doURL(url);
        }
    }
}

