/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RMISecurityManager;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.StartMojo;

public class StartAndWaitMojo
extends StartMojo {
    public static final long ONE_SECOND = 1000L;
    protected int retry;
    protected int retryWait;
    protected int timeout;
    protected String namingPort;
    protected String hostName;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            File policyFile = File.createTempFile("jboss-client", ".policy");
            policyFile.deleteOnExit();
            this.writeSecurityPolicy(policyFile);
            policyFile = policyFile.getCanonicalFile();
            System.setProperty("java.security.policy", policyFile.toURI().toString());
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (IOException e) {
            this.getLog().info((CharSequence)("Unable to create security policy file for loading remote classes: " + e.getMessage()), (Throwable)e);
            this.getLog().info((CharSequence)"Will try to load required classes from local classpath.");
        }
        catch (SecurityException e) {
            this.getLog().info((CharSequence)("Unable to set security manager for loading remote classes: " + e.getMessage()), (Throwable)e);
            this.getLog().info((CharSequence)"Will try to load required classes from local classpath.");
        }
        InitialContext ctx = this.getInitialContext();
        MBeanServerConnection server = null;
        NamingException ne = null;
        for (int i = 0; i < this.retry; ++i) {
            try {
                Thread.sleep(this.retryWait);
                server = (MBeanServerConnection)ctx.lookup("jmx/invoker/RMIAdaptor");
                break;
            }
            catch (NamingException e) {
                ne = e;
                this.getLog().info((CharSequence)"Waiting to retrieve JBoss JMX MBean connection... ");
                continue;
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)("Thread interrupted while waiting for MBean connection: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (server == null) {
            throw new MojoExecutionException("Unable to get JBoss JMX MBean connection: " + ne.getMessage(), (Exception)ne);
        }
        this.getLog().info((CharSequence)"JBoss JMX MBean connection successful!");
        boolean started = false;
        long startTime = System.currentTimeMillis();
        while (!started && System.currentTimeMillis() - startTime < (long)this.timeout) {
            try {
                Thread.sleep(1000L);
                started = this.isStarted(server);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to wait: " + e.getMessage(), e);
            }
        }
        if (!started) {
            throw new MojoExecutionException("JBoss AS is not stared before timeout has expired! ");
        }
        this.getLog().info((CharSequence)"JBoss AS started!");
    }

    protected boolean isStarted(MBeanServerConnection server) throws Exception {
        ObjectName serverMBeanName = new ObjectName("jboss.system:type=Server");
        return (Boolean)server.getAttribute(serverMBeanName, "Started");
    }

    protected InitialContext getInitialContext() throws MojoExecutionException {
        Properties env = new Properties();
        try {
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            env.put("java.naming.provider.url", this.hostName + ":" + this.namingPort);
            return new InitialContext(env);
        }
        catch (NamingException e) {
            throw new MojoExecutionException("Unable to instantiate naming context: " + e.getMessage(), (Exception)e);
        }
    }

    public void writeSecurityPolicy(File policyFile) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(policyFile));
        writer.println("grant {");
        writer.println("    permission java.security.AllPermission;");
        writer.println("};");
        writer.close();
    }
}

