/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreeMarkerHelper {
    public static final String TEMPLATE = "template";
    protected final Configuration freemarkerConfiguration;
    protected final TemplateLoader templateLoader;

    public static FreeMarkerHelper newDefaultHelper() {
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(FreeMarkerHelper.class, "/");
        FreeMarkerHelper result = new FreeMarkerHelper((TemplateLoader)templateLoader);
        return result;
    }

    public static FreeMarkerHelper newHelperFromContent(String stringTemplate) {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate(TEMPLATE, stringTemplate);
        FreeMarkerHelper result = new FreeMarkerHelper((TemplateLoader)templateLoader);
        return result;
    }

    protected FreeMarkerHelper(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setTemplateLoader(templateLoader);
        DefaultObjectWrapper objectWrapper = new DefaultObjectWrapper();
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)objectWrapper);
    }

    public Template getTemplate(String templateName) throws IOException {
        File file = new File(templateName);
        if (file.exists()) {
            this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(file.getParentFile()));
            templateName = file.getName();
        } else {
            this.freemarkerConfiguration.setTemplateLoader(this.templateLoader);
        }
        Template template = this.freemarkerConfiguration.getTemplate(templateName);
        if (template == null) {
            throw new IOException("Could not find template " + templateName);
        }
        return template;
    }

    public String renderTemplate(String templateName, Map<String, Object> parameters) throws IOException {
        Template template = this.getTemplate(templateName);
        return this.renderTemplate(template, parameters);
    }

    public String renderTemplate(Template template, Map<String, Object> parameters) throws IOException {
        StringWriter out = new StringWriter();
        try {
            template.process(parameters, (Writer)out);
        }
        catch (TemplateException e) {
            throw new IOException("Could not render template " + template.getName() + " for reason " + e.getMessage());
        }
        return out.toString();
    }
}

