/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.api.maven;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public final class Artifact
implements Serializable,
Comparable<Artifact> {
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String classifier;
    private final Long timestamp;
    private final Integer buildNumber;
    private transient String name;
    private transient String timestampVersion;

    private Artifact(String groupId, String artifactId, String version, String classifier, String type, Long timestamp, Integer buildNumber) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.timestamp = this.isSnapshot() ? timestamp : null;
        this.buildNumber = this.isSnapshot() ? buildNumber : null;
    }

    public Artifact(String groupId, String artifactId, String version, String classifier, String type, long timestamp, int buildNumber) {
        this(groupId, artifactId, version, classifier, type, (Long)timestamp, (Integer)buildNumber);
    }

    public Artifact(String groupId, String artifactId, String version, String type, long timestamp, int buildNumber) {
        this(groupId, artifactId, version, (String)null, type, new Long(timestamp), new Integer(buildNumber));
    }

    public Artifact(String groupId, String artifactId, String version, String classifier, String type) {
        this(groupId, artifactId, version, classifier, type, null, null);
    }

    public Artifact(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version, null, type);
    }

    public String getName() {
        if (this.name == null) {
            this.name = MessageFormat.format("{0}-{1}{2}.{3}", this.artifactId, this.getTimestampVersion(), this.classifier == null ? "" : "-" + this.classifier, this.type);
        }
        return this.name;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public String getTimestampString() {
        if (this.timestamp == null) {
            return null;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd.HHmmss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date(this.timestamp));
    }

    public String getTimestampVersion() {
        if (this.timestampVersion == null) {
            if (this.timestamp != null) {
                assert (this.isSnapshot());
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd.HHmmss");
                fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.timestampVersion = MessageFormat.format("{0}-{1}-{2}", this.version.substring(0, this.version.length() - "-SNAPSHOT".length()), fmt.format(new Date(this.timestamp)), this.buildNumber);
            } else {
                this.timestampVersion = this.version;
            }
        }
        return this.timestampVersion;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        if (!this.groupId.equals(artifact.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(artifact.artifactId)) {
            return false;
        }
        if (!this.version.equals(artifact.version)) {
            return false;
        }
        if (!this.type.equals(artifact.type)) {
            return false;
        }
        if (!Objects.equals(this.classifier, artifact.classifier)) {
            return false;
        }
        if (!Objects.equals(this.buildNumber, artifact.buildNumber)) {
            return false;
        }
        return Objects.equals(this.timestamp, artifact.timestamp);
    }

    public boolean equalSnapshots(Artifact artifact) {
        if (this == artifact) {
            return true;
        }
        if (!this.groupId.equals(artifact.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(artifact.artifactId)) {
            return false;
        }
        if (!this.version.equals(artifact.version)) {
            return false;
        }
        if (!this.type.equals(artifact.type)) {
            return false;
        }
        return Objects.equals(this.classifier, artifact.classifier);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Artifact");
        sb.append("{").append(this.groupId);
        sb.append(":").append(this.artifactId);
        sb.append(":").append(this.getTimestampVersion());
        if (this.classifier != null) {
            sb.append(":").append(this.classifier);
        }
        sb.append(":").append(this.type);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(Artifact that) {
        int rv = this.getGroupId().compareTo(that.getGroupId());
        return rv == 0 ? this.getName().compareTo(that.getName()) : rv;
    }
}

