/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.mojo.mrm.api.maven.ArchetypeCatalogNotFoundException;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DiskArtifactStore
extends BaseArtifactStore {
    private final File root;
    private boolean canWrite;

    public DiskArtifactStore(File root) {
        this.root = root;
    }

    public DiskArtifactStore canWrite(boolean canWrite) {
        this.canWrite = canWrite;
        return this;
    }

    public Set<String> getGroupIds(String parentGroupId) {
        File parentDir;
        File file = parentDir = StringUtils.isEmpty((String)parentGroupId) ? this.root : new File(this.root, parentGroupId.replace('.', '/'));
        if (!parentDir.isDirectory()) {
            return Collections.emptySet();
        }
        File[] groupDirs = parentDir.listFiles();
        if (groupDirs == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(groupDirs).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
    }

    public Set<String> getArtifactIds(String groupId) {
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        if (!groupDir.isDirectory()) {
            return Collections.emptySet();
        }
        File[] artifactDirs = groupDir.listFiles();
        if (artifactDirs == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(artifactDirs).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        File artifactDir = new File(groupDir, artifactId);
        if (!artifactDir.isDirectory()) {
            return Collections.emptySet();
        }
        File[] dirs = artifactDir.listFiles();
        if (dirs == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(dirs).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
    }

    public Set<Artifact> getArtifacts(final String groupId, final String artifactId, final String version) {
        abstract class ArtifactFactory {
            ArtifactFactory() {
            }

            abstract Artifact get(File var1);
        }
        ArtifactFactory factory;
        Pattern rule;
        File groupDir = new File(this.root, groupId.replace('.', '/'));
        File artifactDir = new File(groupDir, artifactId);
        File versionDir = new File(artifactDir, version);
        if (!versionDir.isDirectory()) {
            return Collections.emptySet();
        }
        if (version.endsWith("-SNAPSHOT")) {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-(?:\\Q" + StringUtils.removeEnd((String)version, (String)"-SNAPSHOT") + "\\E-(SNAPSHOT|(\\d{4})(\\d{2})(\\d{2})\\.(\\d{2})(\\d{2})(\\d{2})-(\\d+)))(?:-([^.]+))?\\.([^/]*)");
            factory = new ArtifactFactory(){
                {
                }

                @Override
                public Artifact get(File file) {
                    Matcher matcher = rule.matcher(file.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    if (matcher.group(1).equals("SNAPSHOT")) {
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10));
                    }
                    try {
                        GregorianCalendar cal = new GregorianCalendar();
                        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
                        cal.set(1, Integer.parseInt(matcher.group(2)));
                        cal.set(2, Integer.parseInt(matcher.group(3)) - 1);
                        cal.set(5, Integer.parseInt(matcher.group(4)));
                        cal.set(11, Integer.parseInt(matcher.group(5)));
                        cal.set(12, Integer.parseInt(matcher.group(6)));
                        cal.set(13, Integer.parseInt(matcher.group(7)));
                        long timestamp = cal.getTimeInMillis();
                        int buildNumber = Integer.parseInt(matcher.group(8));
                        return new Artifact(groupId, artifactId, version, matcher.group(9), matcher.group(10), timestamp, buildNumber);
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
            };
        } else {
            rule = Pattern.compile("\\Q" + artifactId + "\\E-\\Q" + version + "\\E(?:-([^.]+))?\\.(.+)");
            factory = new ArtifactFactory(){
                {
                }

                @Override
                public Artifact get(File file) {
                    Matcher matcher = rule.matcher(file.getName());
                    if (!matcher.matches()) {
                        return null;
                    }
                    return new Artifact(groupId, artifactId, version, matcher.group(1), matcher.group(2));
                }
            };
        }
        File[] files = versionDir.listFiles();
        HashSet<Artifact> result = new HashSet<Artifact>(files.length);
        for (File file : files) {
            Artifact artifact;
            if (!file.isFile() || !rule.matcher(file.getName()).matches() || (artifact = factory.get(file)) == null) continue;
            result.add(artifact);
        }
        return result;
    }

    public long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File file = this.getFile(artifact);
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return file.lastModified();
    }

    public long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File file = this.getFile(artifact);
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return file.length();
    }

    public InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        File file = this.getFile(artifact);
        if (!file.isFile()) {
            throw new ArtifactNotFoundException(artifact);
        }
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Artifact artifact, InputStream content) throws IOException {
        if (!this.canWrite) {
            throw new UnsupportedOperationException("Read-only store");
        }
        File targetFile = this.getFile(artifact);
        if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create " + targetFile.getParentFile().getPath());
        }
        try (OutputStream output = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)content, (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Metadata metadata;
        block10: {
            String[] parts;
            File file = this.root;
            for (String part : parts = StringUtils.strip((String)path, (String)"/").split("/")) {
                file = new File(file, part);
            }
            if (!(file = new File(file, "maven-metadata.xml")).isFile()) {
                throw new MetadataNotFoundException(path);
            }
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                metadata = new MetadataXpp3Reader().read(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return metadata;
    }

    public void setMetadata(String path, Metadata metadata) throws IOException {
        String[] parts;
        if (!this.canWrite) {
            throw new UnsupportedOperationException("Read-only store");
        }
        File file = this.root;
        for (String part : parts = StringUtils.strip((String)path, (String)"/").split("/")) {
            file = new File(file, part);
        }
        file = new File(file, "maven-metadata.xml");
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new MetadataXpp3Writer().write(outputStream, metadata);
        }
    }

    public long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        File file = this.root;
        String[] parts = StringUtils.strip((String)path, (String)"/").split("/");
        Stack<File> stack = new Stack<File>();
        for (int i = 0; i < parts.length; ++i) {
            if ("..".equals(parts[i])) {
                if (!stack.isEmpty()) {
                    file = (File)stack.pop();
                    continue;
                }
                file = this.root;
                continue;
            }
            if (".".equals(parts[i])) continue;
            file = new File(file, parts[i]);
            stack.push(file);
        }
        if (!(file = new File(file, "maven-metadata.xml")).isFile()) {
            throw new MetadataNotFoundException(path);
        }
        return file.lastModified();
    }

    public ArchetypeCatalog getArchetypeCatalog() throws IOException, ArchetypeCatalogNotFoundException {
        ArchetypeCatalog archetypeCatalog;
        block9: {
            File file = new File(this.root, "archetype-catalog.xml");
            if (!file.isFile()) {
                throw new ArchetypeCatalogNotFoundException();
            }
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                archetypeCatalog = new ArchetypeCatalogXpp3Reader().read(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return archetypeCatalog;
    }

    public long getArchetypeCatalogLastModified() throws IOException, ArchetypeCatalogNotFoundException {
        File file = new File(this.root, "archetype-catalog.xml");
        if (!file.isFile()) {
            throw new ArchetypeCatalogNotFoundException();
        }
        return file.lastModified();
    }

    private File getFile(Artifact artifact) {
        File groupDir = new File(this.root, artifact.getGroupId().replace('.', '/'));
        File artifactDir = new File(groupDir, artifact.getArtifactId());
        File versionDir = new File(artifactDir, artifact.getVersion());
        return new File(versionDir, artifact.getName());
    }
}

