/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rmic.RmiCompiler;
import org.codehaus.mojo.rmic.RmiCompilerConfiguration;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractRmiCompiler
implements RmiCompiler {
    private Log logger;
    private static ClassLoaderFacade classLoaderFacade = new ClassLoaderFacadeImpl();

    AbstractRmiCompiler() {
    }

    @Override
    public void setLog(Log log) {
        this.logger = log;
    }

    @Override
    public Log getLog() {
        return this.logger;
    }

    static ClassLoaderFacade getClassLoaderFacade() {
        return classLoaderFacade;
    }

    @Override
    public void execute(RmiCompilerConfiguration rmiConfig) throws RmiCompilerException {
        ArrayList<String> arguments = new ArrayList<String>();
        List<String> classpathList = rmiConfig.getClasspathEntries();
        if (classpathList.size() > 0) {
            arguments.add("-classpath");
            arguments.add(this.buildClasspath(classpathList));
        }
        arguments.add("-d");
        arguments.add(rmiConfig.getOutputLocation());
        if (rmiConfig.getVersion() != null) {
            arguments.add("-v" + rmiConfig.getVersion());
        }
        if (rmiConfig.isIiop()) {
            arguments.add("-iiop");
            if (rmiConfig.isPoa()) {
                arguments.add("-poa");
            }
            if (rmiConfig.isNoLocalStubs()) {
                arguments.add("-nolocalstubs");
            }
        } else if (rmiConfig.isPoa()) {
            throw new RmiCompilerException("IIOP must be enabled in order to use the POA option");
        }
        if (rmiConfig.isIdl()) {
            arguments.add("-idl");
            if (rmiConfig.isNoValueMethods()) {
                arguments.add("-noValueMethods");
            }
        }
        if (rmiConfig.isKeep()) {
            arguments.add("-keep");
        }
        if (this.getLog().isDebugEnabled() || rmiConfig.isVerbose()) {
            arguments.add("-verbose");
        } else if (rmiConfig.isNowarn()) {
            arguments.add("-nowarn");
        }
        for (File remoteClass : rmiConfig.getSourceFiles()) {
            arguments.add(AbstractRmiCompiler.fileToClassName(remoteClass.getPath()));
        }
        String[] args = arguments.toArray(new String[arguments.size()]);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"rmic arguments: ");
            for (String arg : args) {
                this.getLog().debug((CharSequence)arg);
            }
        }
        try {
            this.compileInProcess(args);
        }
        catch (CompilerException e) {
            throw new RmiCompilerException(e.getMessage(), e);
        }
    }

    private String buildClasspath(List<String> classpathList) {
        StringBuilder classpath = new StringBuilder(classpathList.get(0));
        for (int i = 1; i < classpathList.size(); ++i) {
            classpath.append(File.pathSeparator).append(classpathList.get(i));
        }
        return classpath.toString();
    }

    private static String fileToClassName(String classFileName) {
        return StringUtils.replace((String)StringUtils.replace((String)classFileName, (String)".class", (String)""), (String)File.separator, (String)".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileInProcess(String[] args) throws CompilerException {
        Class<?> mainClass = this.createMainClass();
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(mainClass.getClassLoader());
        try {
            AbstractRmiCompiler.compileInProcess0(mainClass, args);
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected abstract Class<?> createMainClass() throws CompilerException;

    private static void compileInProcess0(Class<?> rmicMainClass, String[] args) throws CompilerException {
        try {
            Constructor<?> constructor = rmicMainClass.getConstructor(OutputStream.class, String.class);
            Object main = constructor.newInstance(System.out, "rmic");
            Method compile = rmicMainClass.getMethod("compile", String[].class);
            compile.invoke(main, new Object[]{args});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
    }

    private static class ClassLoaderFacadeImpl
    implements ClassLoaderFacade {
        ClassLoader classLoader = this.getClass().getClassLoader();

        private ClassLoaderFacadeImpl() {
        }

        @Override
        public void prependUrls(URL ... urls) {
            this.classLoader = new URLClassLoader(urls, this.classLoader);
        }

        @Override
        public Class<?> loadClass(String rmiCompilerClass) throws ClassNotFoundException {
            return this.classLoader.loadClass(rmiCompilerClass);
        }
    }

    static interface ClassLoaderFacade {
        public void prependUrls(URL ... var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

