/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.platform.detective;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.mojo.tools.platform.detective.OsPattern;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformPropertyPatterns
implements Contextualizable {
    public static final String DEFAULT_DYNPROP_OS = "DYNAMIC.CBUILDPROP.OS";
    public static final String DEFAULT_DYNPROP_ARCH = "DYNAMIC.CBUILDPROP.ARCH";
    public static final String DEFAULT_DYNPROP_RPMVERSION = "DYNAMIC.CBUILDPROP.RPM.VERSION";
    public static final String DEFAULT_DYNPROP_RPMRELEASE = "DYNAMIC.CBUILDPROP.RPM.RELEASE";
    public static final String ROLE = PlatformPropertyPatterns.class.getName();
    public static final String ROLE_HINT = "default";
    public static final String SYSTEM_PROPERTY_PREFIX = "sysprop:";
    private Context containerContext;
    private PlexusContainer container;
    private static final String CONTAINER_KEY = "platformPropertyPatterns:context-container";
    private static final String OS_PATTERNS_KEY = "os-patterns";
    public static final String REF = "ref:";
    public static final String FEDORA_PATTERN = "Fedora Core release ([0-9]+) .*";
    public static final String FEDORA_SOURCE = "fedora-release";
    public static final String FEDORA_REF = "fedora";
    public static final String REDHAT_ENTERPRISE_PATTERN = "Red Hat Enterprise Linux .* release ([0-9]+)";
    public static final String REDHAT_ENTERPRISE_SOURCE = "redhat-release";
    public static final String REDHAT_ENTERPRISE_REF = "redhat-enterprise";
    public static final String REDHAT_PATTERN = "Red Hat Linux release ([0-9]+)";
    public static final String REDHAT_SOURCE = "redhat-release";
    public static final String REDHAT_REF = "redhat";
    public static final String GENTOO_PATTERN = "Gentoo Base System release ([0-9]+).([0-9]+)";
    public static final String GENTOO_SOURCE = "gentoo-release";
    public static final String GENTOO_REF = "gentoo";
    public static final String LSB_PATTERN = "DISTRIB_RELEASE=([-.0-9]+)";
    public static final String LSB_SOURCE = "lsb-release";
    public static final String LSB_REF = "lsb";
    public static final String DEBIAN_PATTERN = "([.0-9]+)";
    public static final String DEBIAN_SOURCE = "debian_version";
    public static final String DEBIAN_REF = "debian";
    public static final String CENTOS_PATTERN = "CentOS release ([.0-9]+)";
    public static final String CENTOS_SOURCE = "redhat-release";
    public static final String CENTOS_REF = "centos";
    public static final String DARWIN_PATTERN = "OSX release 10.([0-9]+)";
    public static final String DARWIN_SOURCE = "os.name";
    public static final String DARWIN_REF = "osx";
    public static final String WINDOWS_PATTERN = "Windows release ([0-9]+)";
    public static final String WINDOWS_SOURCE = "os.name";
    public static final String WINDOWS_REF = "win";
    private static final Map<String, String> COMMON_PATTERNS = new HashMap<String, String>(){
        private static final long serialVersionUID = 2L;
        {
            this.put(PlatformPropertyPatterns.FEDORA_REF, PlatformPropertyPatterns.FEDORA_PATTERN);
            this.put(PlatformPropertyPatterns.REDHAT_ENTERPRISE_REF, PlatformPropertyPatterns.REDHAT_ENTERPRISE_PATTERN);
            this.put(PlatformPropertyPatterns.REDHAT_REF, PlatformPropertyPatterns.REDHAT_PATTERN);
            this.put(PlatformPropertyPatterns.CENTOS_REF, PlatformPropertyPatterns.CENTOS_PATTERN);
            this.put(PlatformPropertyPatterns.GENTOO_REF, PlatformPropertyPatterns.GENTOO_PATTERN);
            this.put(PlatformPropertyPatterns.LSB_REF, PlatformPropertyPatterns.LSB_PATTERN);
            this.put(PlatformPropertyPatterns.DARWIN_REF, PlatformPropertyPatterns.DARWIN_PATTERN);
            this.put(PlatformPropertyPatterns.WINDOWS_REF, PlatformPropertyPatterns.WINDOWS_PATTERN);
        }
    };
    private static final Map<String, String> COMMON_SOURCES = new HashMap<String, String>(){
        private static final long serialVersionUID = 2L;
        {
            this.put(PlatformPropertyPatterns.FEDORA_REF, PlatformPropertyPatterns.FEDORA_SOURCE);
            this.put(PlatformPropertyPatterns.REDHAT_ENTERPRISE_REF, "redhat-release");
            this.put(PlatformPropertyPatterns.REDHAT_REF, "redhat-release");
            this.put(PlatformPropertyPatterns.CENTOS_REF, "redhat-release");
            this.put(PlatformPropertyPatterns.GENTOO_REF, PlatformPropertyPatterns.GENTOO_SOURCE);
            this.put(PlatformPropertyPatterns.LSB_REF, PlatformPropertyPatterns.LSB_SOURCE);
            this.put(PlatformPropertyPatterns.DARWIN_REF, "os.name");
            this.put(PlatformPropertyPatterns.WINDOWS_REF, "os.name");
        }
    };
    public static final PlatformPropertyPatterns DEFAULT_PATTERNS = new PlatformPropertyPatterns(){
        {
            this.addOsPattern(PlatformPropertyPatterns.FEDORA_SOURCE, PlatformPropertyPatterns.FEDORA_PATTERN, "fc$1");
            this.addOsPattern("redhat-release", PlatformPropertyPatterns.REDHAT_ENTERPRISE_PATTERN, "rhel$1");
            this.addOsPattern("redhat-release", PlatformPropertyPatterns.REDHAT_PATTERN, "rh$1");
            this.addOsPattern(PlatformPropertyPatterns.GENTOO_SOURCE, PlatformPropertyPatterns.GENTOO_PATTERN, "gentoo$1.$2");
            this.addOsPattern(PlatformPropertyPatterns.LSB_SOURCE, PlatformPropertyPatterns.LSB_PATTERN, "lsb$1");
            this.addOsPattern(PlatformPropertyPatterns.DEBIAN_SOURCE, PlatformPropertyPatterns.DEBIAN_PATTERN, "debian$1");
            this.addOsPattern("redhat-release", PlatformPropertyPatterns.CENTOS_PATTERN, "centos$1");
            this.addOsPattern("os.name", PlatformPropertyPatterns.WINDOWS_PATTERN, "win$1");
            this.addOsPattern("os.name", PlatformPropertyPatterns.DARWIN_PATTERN, "osx$1");
        }
    };
    private Map<String, Properties> osPatternsBySource;

    public String getOperatingSystemToken(String source, String operatingSystem) {
        Properties props;
        String prop = this.extractProperty(operatingSystem = operatingSystem.trim(), props = this.osPatternsBySource.get(source = source.trim()));
        return prop == null ? null : prop.trim();
    }

    public void setOsPatterns(List<OsPattern> osPatterns) {
        this.osPatternsBySource = PlatformPropertyPatterns.DEFAULT_PATTERNS.osPatternsBySource;
        for (OsPattern osPattern : osPatterns) {
            this.addOsPattern(osPattern.getSource(), osPattern.getExpression(), osPattern.getToken());
        }
    }

    public void addOsPattern(OsPattern osPattern) {
        this.addOsPattern(osPattern.getSource(), osPattern.getExpression(), osPattern.getToken());
    }

    public void addOsPattern(String originalSource, String originalPattern, String extractor) {
        Properties osPatterns;
        String source = PlatformPropertyPatterns.get(COMMON_SOURCES, originalSource);
        if (this.osPatternsBySource == null) {
            this.osPatternsBySource = new HashMap<String, Properties>();
        }
        if ((osPatterns = this.osPatternsBySource.get(source)) == null) {
            osPatterns = new Properties();
            this.osPatternsBySource.put(source, osPatterns);
        }
        String pattern = PlatformPropertyPatterns.get(COMMON_PATTERNS, originalPattern);
        osPatterns.setProperty(pattern, extractor);
    }

    private static String get(Map<String, String> map, String key) {
        if (key.startsWith(REF)) {
            return map.get(key.substring(REF.length()));
        }
        return key;
    }

    private String extractProperty(String realValue, Properties patterns) {
        realValue = realValue.trim();
        System.out.println("extractProperty:: '" + realValue + "' " + patterns);
        if (patterns == null || patterns.keySet() == null || patterns.keySet().iterator() == null) {
            System.out.println("NO Patterns are available !!");
            return null;
        }
        for (String string : patterns.keySet()) {
            Matcher matcher = Pattern.compile(string, 10).matcher(realValue);
            if (!matcher.matches() && !matcher.find(0)) continue;
            return this.replaceReferences(patterns.getProperty(string), matcher);
        }
        return null;
    }

    String replaceReferences(String extraction, Matcher valueSource) {
        int groupCount = valueSource.groupCount();
        String result = extraction;
        for (int i = 0; i <= groupCount; ++i) {
            String group = valueSource.group(i);
            result = result.replaceAll("\\$" + i, group);
        }
        return result;
    }

    public void contextualize(Context context) throws ContextException {
        this.containerContext = context;
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

