/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen.generation.velocity;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;
import org.codehaus.mojo.servicedocgen.descriptor.ServicesDescriptor;
import org.codehaus.mojo.servicedocgen.generation.ServicesGenerator;

public class VelocityServicesGenerator
implements ServicesGenerator {
    private static final String ENCODING = "UTF-8";
    private final String templatePath;
    private final Context context;
    private Template template;
    private final VelocityEngine engine = new VelocityEngine();

    public VelocityServicesGenerator(String templatePath) {
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
        ToolManager manager = new ToolManager();
        this.context = manager.createContext();
        this.templatePath = templatePath;
        this.template = this.engine.getTemplate(templatePath, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(ServicesDescriptor descriptor, File outputDirectory) throws IOException {
        this.context.put("services", (Object)descriptor);
        String filename = "index.html";
        File outputFile = new File(outputDirectory, filename);
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, ENCODING);
            this.template.merge(this.context, (Writer)writer);
            ((Writer)writer).close();
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

