/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.servicedocgen.introspection;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import org.codehaus.mojo.servicedocgen.Util;
import org.codehaus.mojo.servicedocgen.introspection.JException;
import org.codehaus.mojo.servicedocgen.introspection.JParameter;
import org.codehaus.mojo.servicedocgen.introspection.JReturn;
import org.codehaus.mojo.servicedocgen.introspection.JType;
import org.codehaus.mojo.servicedocgen.introspection.JavaDocHelper;

public class JMethod {
    private final JType type;
    private final JavaMethod sourceMethod;
    private final Method byteMethod;
    private final List<JParameter> parameters;
    private final List<JException> exceptions;
    private final JReturn returns;
    private final String comment;

    public JMethod(Method byteMethod, JType type) {
        this(byteMethod, type, byteMethod);
    }

    public JMethod(Method byteMethod, JType type, Method annotatedParentMethod) {
        this.type = type;
        this.byteMethod = byteMethod;
        JavaClass sourceType = type.getSourceType();
        GenericType<?> byteType = type.getByteType();
        ReflectionUtil reflectionUtil = type.getReflectionUtil();
        JavaDocHelper javaDocHelper = type.getJavaDocHelper();
        this.sourceMethod = JMethod.findSourceMethod(sourceType, byteMethod);
        List parameterSourceInfos = null;
        Map<String, String> parameterMap = null;
        List exceptionSourceTypes = null;
        Map<String, String> exceptionMap = null;
        JavaClass returnSourceType = null;
        String returnComment = "";
        if (this.sourceMethod != null) {
            this.comment = javaDocHelper.parseJavaDoc(sourceType, byteType, this.sourceMethod.getComment());
            parameterSourceInfos = this.sourceMethod.getParameters();
            parameterMap = JMethod.getTagListAsMap(this.sourceMethod.getTagsByName("param"), false);
            exceptionSourceTypes = this.sourceMethod.getExceptions();
            exceptionMap = JMethod.getTagListAsMap(this.sourceMethod.getTagsByName("throws"), true);
            DocletTag returnTag = this.sourceMethod.getTagByName("return");
            if (returnTag != null) {
                returnComment = javaDocHelper.parseJavaDoc(sourceType, byteType, returnTag.getValue());
            }
            returnSourceType = this.sourceMethod.getReturns();
        } else {
            this.comment = "";
        }
        Type[] parameterByteTypes = byteMethod.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = annotatedParentMethod.getParameterAnnotations();
        this.parameters = new ArrayList<JParameter>(parameterByteTypes.length);
        this.sourceMethod.getParameters();
        for (int i = 0; i < parameterByteTypes.length; ++i) {
            GenericType parameterByteType = reflectionUtil.createGenericType(parameterByteTypes[i], byteType);
            JavaParameter parameterSourceType = (JavaParameter)JMethod.get(parameterSourceInfos, i);
            String parameterComment = "";
            if (parameterSourceType != null && parameterMap != null) {
                parameterComment = javaDocHelper.parseJavaDoc(sourceType, byteType, parameterMap.get(parameterSourceType.getName()));
            }
            this.parameters.add(new JParameter(parameterByteType, parameterAnnotations[i], parameterSourceType, parameterComment, i));
        }
        Type[] exceptionByteTypes = byteMethod.getGenericExceptionTypes();
        this.exceptions = new ArrayList<JException>(exceptionByteTypes.length);
        for (int i = 0; i < exceptionByteTypes.length; ++i) {
            JavaClass exceptionSourceType = (JavaClass)JMethod.get(exceptionSourceTypes, i);
            GenericType exceptionByteType = reflectionUtil.createGenericType(exceptionByteTypes[i], byteType);
            String exceptionComment = "";
            if (exceptionMap != null) {
                exceptionComment = javaDocHelper.parseJavaDoc(sourceType, byteType, exceptionMap.get(exceptionByteType.getAssignmentClass().getSimpleName()));
            }
            this.exceptions.add(new JException(exceptionByteType, exceptionSourceType, exceptionComment));
        }
        GenericType returnByteType = reflectionUtil.createGenericType(byteMethod.getGenericReturnType(), byteType);
        this.returns = new JReturn(returnByteType, returnSourceType, returnComment);
    }

    private static <T> T get(List<T> list, int index) {
        if (list == null) {
            return null;
        }
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private static JavaMethod findSourceMethod(JavaClass sourceClass, Method byteMethod) {
        for (JavaMethod sourceMethod : sourceClass.getMethods()) {
            if (!sourceMethod.getName().equals(byteMethod.getName())) continue;
            List sourceParameters = sourceMethod.getParameters();
            Class<?>[] byteParameters = byteMethod.getParameterTypes();
            if (sourceParameters.size() != byteParameters.length) continue;
            for (int i = 0; i < byteParameters.length; ++i) {
                String sourceTypeName;
                String byteTypeName = byteParameters[i].getName();
                if (byteTypeName.equals(sourceTypeName = ((JavaParameter)sourceParameters.get(i)).getType().getFullyQualifiedName())) continue;
                return null;
            }
            return sourceMethod;
        }
        return null;
    }

    private static Map<String, String> getTagListAsMap(List<DocletTag> tagList, boolean simpleName) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (DocletTag tag : tagList) {
            String value = tag.getValue();
            int firstSpace = value.indexOf(32);
            if (firstSpace <= 0) continue;
            String subTag = value.substring(0, firstSpace);
            if (simpleName) {
                subTag = Util.getSimpleName(subTag);
            }
            String comment = value.substring(firstSpace + 1);
            map.put(subTag, comment);
        }
        return map;
    }

    public JType getType() {
        return this.type;
    }

    public JavaMethod getSourceMethod() {
        return this.sourceMethod;
    }

    public Method getByteMethod() {
        return this.byteMethod;
    }

    public List<JParameter> getParameters() {
        return this.parameters;
    }

    public List<JException> getExceptions() {
        return this.exceptions;
    }

    public JReturn getReturns() {
        return this.returns;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.byteMethod.getName();
    }

    public String toString() {
        return this.byteMethod.toString();
    }
}

