package org.codehaus.mojo.tomcat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on tomcat-maven-plugin.<br/> Call <pre>  mvn tomcat:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Oct 06 16:52:20 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:tomcat-maven-plugin:1.1", 0 );
        append( sb, "", 0 );

        append( sb, "Tomcat Maven Plugin", 0 );
        append( sb, "The Tomcat Maven Plugin provides goals to manipulate WAR projects within the Tomcat servlet container.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 19 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "deploy".equals( goal ) )
        {
            append( sb, "tomcat:deploy", 0 );
            append( sb, "Deploy a WAR to Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: war)", 2 );
                append( sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The Tomcat webapp tag name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "update (Default: false)", 2 );
                append( sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "warFile", 2 );
                append( sb, "The path of the WAR file to deploy.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "deploy-only".equals( goal ) )
        {
            append( sb, "tomcat:deploy-only", 0 );
            append( sb, "Deploy a WAR to Tomcat witjout forking the package lifecycle", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: war)", 2 );
                append( sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The Tomcat webapp tag name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "update (Default: false)", 2 );
                append( sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "warFile", 2 );
                append( sb, "The path of the WAR file to deploy.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "exploded".equals( goal ) )
        {
            append( sb, "tomcat:exploded", 0 );
            append( sb, "Deploy an exploded WAR to Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: war)", 2 );
                append( sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The Tomcat webapp tag name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "update (Default: false)", 2 );
                append( sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "warDirectory", 2 );
                append( sb, "The path of the exploded WAR directory to deploy.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "tomcat:help", 0 );
            append( sb, "Display help information on tomcat-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0tomcat:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "info".equals( goal ) )
        {
            append( sb, "tomcat:info", 0 );
            append( sb, "Lists information about the Tomcat version, OS, and JVM properties.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "inplace".equals( goal ) )
        {
            append( sb, "tomcat:inplace", 0 );
            append( sb, "Deploy a WAR in-place to Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: war)", 2 );
                append( sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The Tomcat webapp tag name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "update (Default: false)", 2 );
                append( sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory", 2 );
                append( sb, "The path of the inplace WAR directory to deploy.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list".equals( goal ) )
        {
            append( sb, "tomcat:list", 0 );
            append( sb, "Lists all the currently deployed web applications in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "redeploy".equals( goal ) )
        {
            append( sb, "tomcat:redeploy", 0 );
            append( sb, "Redeploy a WAR in Tomcat. Deploy with forcing update flag to true", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mode (Default: war)", 2 );
                append( sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "tag", 2 );
                append( sb, "The Tomcat webapp tag name to use.", 3 );
                append( sb, "", 0 );

                append( sb, "update (Default: false)", 2 );
                append( sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "warFile", 2 );
                append( sb, "The path of the WAR file to deploy.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "reload".equals( goal ) )
        {
            append( sb, "tomcat:reload", 0 );
            append( sb, "Reload a WAR in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resources".equals( goal ) )
        {
            append( sb, "tomcat:resources", 0 );
            append( sb, "Lists JNDI resources in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "type", 2 );
                append( sb, "The class name of the resources to list, or null for all.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "roles".equals( goal ) )
        {
            append( sb, "tomcat:roles", 0 );
            append( sb, "Lists security roles in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run".equals( goal ) )
        {
            append( sb, "tomcat:run", 0 );
            append( sb, "Runs the current project as a dynamic web application using an embedded Tomcat server.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addContextWarDependencies (Default: false)", 2 );
                append( sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it\'s false by default.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2 );
                append( sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3 );
                append( sb, "", 0 );

                append( sb, "classesDir", 2 );
                append( sb, "The classes directory for the web application being run.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDir", 2 );
                append( sb, "The directory to create the Tomcat server configuration under.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "delegate (Default: true)", 2 );
                append( sb, "Set the \'follow standard delegation model\' flag used to configure our ClassLoader.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: false)", 2 );
                append( sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3 );
                append( sb, "", 0 );

                append( sb, "httpsPort (Default: 0)", 2 );
                append( sb, "The https port to run the Tomcat server on. By default it\'s 0 this means won\'t be started. The https connector will be started only for value > 0.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keystoreFile", 2 );
                append( sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "keystorePass", 2 );
                append( sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port to run the Tomcat server on.", 3 );
                append( sb, "", 0 );

                append( sb, "serverXml", 2 );
                append( sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass to the Tomcat Server.", 3 );
                append( sb, "", 0 );

                append( sb, "tomcatWebXml", 2 );
                append( sb, "overriding the providing web.xml to run tomcat", 3 );
                append( sb, "", 0 );

                append( sb, "uriEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "The character encoding to use for decoding URIs.", 3 );
                append( sb, "", 0 );

                append( sb, "useSeparateTomcatClassLoader (Default: false)", 2 );
                append( sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3 );
                append( sb, "", 0 );

                append( sb, "warSourceDirectory", 2 );
                append( sb, "The web resources directory for the web application being run.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run-war".equals( goal ) )
        {
            append( sb, "tomcat:run-war", 0 );
            append( sb, "Runs the current project as a packaged web application using an embedded Tomcat server.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addContextWarDependencies (Default: false)", 2 );
                append( sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it\'s false by default.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2 );
                append( sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDir", 2 );
                append( sb, "The directory to create the Tomcat server configuration under.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: false)", 2 );
                append( sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3 );
                append( sb, "", 0 );

                append( sb, "httpsPort (Default: 0)", 2 );
                append( sb, "The https port to run the Tomcat server on. By default it\'s 0 this means won\'t be started. The https connector will be started only for value > 0.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keystoreFile", 2 );
                append( sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "keystorePass", 2 );
                append( sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port to run the Tomcat server on.", 3 );
                append( sb, "", 0 );

                append( sb, "serverXml", 2 );
                append( sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass to the Tomcat Server.", 3 );
                append( sb, "", 0 );

                append( sb, "tomcatWebXml", 2 );
                append( sb, "overriding the providing web.xml to run tomcat", 3 );
                append( sb, "", 0 );

                append( sb, "uriEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "The character encoding to use for decoding URIs.", 3 );
                append( sb, "", 0 );

                append( sb, "useSeparateTomcatClassLoader (Default: false)", 2 );
                append( sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3 );
                append( sb, "", 0 );

                append( sb, "warDirectory", 2 );
                append( sb, "The path of the exploded WAR directory to run.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run-war-only".equals( goal ) )
        {
            append( sb, "tomcat:run-war-only", 0 );
            append( sb, "Runs the current project as a packaged web application using an embedded Tomcat server without forking the package cycle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addContextWarDependencies (Default: false)", 2 );
                append( sb, "Will create a tomcat context for each dependencies of war type. To preserve backward compatibility it\'s false by default.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2 );
                append( sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3 );
                append( sb, "", 0 );

                append( sb, "configurationDir", 2 );
                append( sb, "The directory to create the Tomcat server configuration under.", 3 );
                append( sb, "", 0 );

                append( sb, "contextFile", 2 );
                append( sb, "The path of the Tomcat context XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: false)", 2 );
                append( sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3 );
                append( sb, "", 0 );

                append( sb, "httpsPort (Default: 0)", 2 );
                append( sb, "The https port to run the Tomcat server on. By default it\'s 0 this means won\'t be started. The https connector will be started only for value > 0.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keystoreFile", 2 );
                append( sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "keystorePass", 2 );
                append( sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifacts", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port to run the Tomcat server on.", 3 );
                append( sb, "", 0 );

                append( sb, "serverXml", 2 );
                append( sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass to the Tomcat Server.", 3 );
                append( sb, "", 0 );

                append( sb, "tomcatWebXml", 2 );
                append( sb, "overriding the providing web.xml to run tomcat", 3 );
                append( sb, "", 0 );

                append( sb, "uriEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "The character encoding to use for decoding URIs.", 3 );
                append( sb, "", 0 );

                append( sb, "useSeparateTomcatClassLoader (Default: false)", 2 );
                append( sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3 );
                append( sb, "", 0 );

                append( sb, "warDirectory", 2 );
                append( sb, "The path of the exploded WAR directory to run.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "sessions".equals( goal ) )
        {
            append( sb, "tomcat:sessions", 0 );
            append( sb, "Lists session information for a WAR in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "shutdown".equals( goal ) )
        {
            append( sb, "tomcat:shutdown", 0 );
            append( sb, "Shuts down all possibly started embedded tomcat servers. This will be automatically down through a shutdown hook or you may call this Mojo to shut them down explictly.\n\nBy default the shutdown goal is not bound to any phase. For integration tests you might want to bind it to post-integration-test.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "start".equals( goal ) )
        {
            append( sb, "tomcat:start", 0 );
            append( sb, "Start a WAR in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stop".equals( goal ) )
        {
            append( sb, "tomcat:stop", 0 );
            append( sb, "Stop a WAR in Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "undeploy".equals( goal ) )
        {
            append( sb, "tomcat:undeploy", 0 );
            append( sb, "Undeploy a WAR from Tomcat.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "charset (Default: ISO-8859-1)", 2 );
                append( sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Whether to fail the build if the web application cannot be undeployed.", 3 );
                append( sb, "", 0 );

                append( sb, "ignorePackaging (Default: false)", 2 );
                append( sb, "If set to true ignore if packaging of project is not \'war\'.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password to use for deployment", 3 );
                append( sb, "", 0 );

                append( sb, "path (Default: /${project.artifactId})", 2 );
                append( sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash (\'/\').", 3 );
                append( sb, "", 0 );

                append( sb, "server", 2 );
                append( sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3 );
                append( sb, "", 0 );

                append( sb, "url (Default: http://localhost:8080/manager)", 2 );
                append( sb, "The full URL of the Tomcat manager instance to use.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The tomcat username to use for deployment", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
