/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public class ArtifactVersions
extends AbstractVersionDetails {
    private final Artifact artifact;
    private final SortedSet versions;
    private final VersionComparator versionComparator;

    public ArtifactVersions(Artifact artifact, List versions, VersionComparator versionComparator) {
        this.artifact = artifact;
        this.versionComparator = versionComparator;
        this.versions = new TreeSet(versionComparator);
        this.versions.addAll(versions);
        if (artifact.getVersion() != null) {
            this.setCurrentVersion(artifact.getVersion());
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getGroupId() {
        return this.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.getArtifact().getArtifactId();
    }

    public ArtifactVersion[] getVersions(boolean includeSnapshots) {
        TreeSet<ArtifactVersion> result;
        if (includeSnapshots) {
            result = this.versions;
        } else {
            result = new TreeSet<ArtifactVersion>(this.versionComparator);
            Iterator i = this.versions.iterator();
            while (i.hasNext()) {
                ArtifactVersion candidate = (ArtifactVersion)i.next();
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                result.add(candidate);
            }
        }
        return result.toArray(new ArtifactVersion[result.size()]);
    }

    public VersionComparator getVersionComparator() {
        return this.versionComparator;
    }
}

