/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-next-versions", threadSafe=true)
public class UseNextVersionsMojo
extends UseLatestVersionsMojoBase {
    @Inject
    public UseNextVersionsMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useNextVersions(pom, dependencyManagement.getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useNextVersions(pom, this.getProject().getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useNextVersions(pom, Collections.singletonList(this.getParentDependency()), ChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useNextVersions(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, ChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        this.useLatestVersions(pom, dependencies, (dep, versions) -> Optional.of(versions.getNewerVersions(dep.getVersion(), this.allowSnapshots)[0]), changeKind, new Predicate[0]);
    }
}

