/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;

public class PropertyVersionsBuilder {
    private final String name;
    private final String profileId;
    private final Set<ArtifactAssociation> associations;
    private final Map<String, Boolean> upperBounds = new LinkedHashMap<String, Boolean>();
    private final Map<String, Boolean> lowerBounds = new LinkedHashMap<String, Boolean>();
    private final Log log;
    private final VersionsHelper helper;
    private ArtifactVersion currentVersion;
    private VersionRange currentVersionRange;

    PropertyVersionsBuilder(VersionsHelper helper, String profileId, String name, Log log) {
        this.helper = helper;
        this.profileId = profileId;
        this.name = name;
        this.associations = new TreeSet<ArtifactAssociation>();
        this.log = log;
    }

    public PropertyVersionsBuilder withAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.add(new DefaultArtifactAssociation(artifact, usePluginRepositories));
        return this;
    }

    public void clearAssociations() {
        this.associations.clear();
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public PropertyVersions build() throws VersionRetrievalException {
        SortedSet<ArtifactVersion> resolvedVersions = this.resolveAssociatedVersions(this.helper, this.associations);
        PropertyVersions instance = new PropertyVersions(this.profileId, this.name, this.log, this.associations, resolvedVersions);
        instance.setCurrentVersion(this.currentVersion);
        instance.setCurrentVersionRange(this.currentVersionRange);
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getVersionRange() {
        if (this.lowerBounds.isEmpty() && this.upperBounds.isEmpty()) {
            return null;
        }
        Optional<Pair> lowerBound = this.lowerBounds.entrySet().stream().min(Map.Entry.comparingByKey()).map(e -> Pair.of((Object)((String)e.getKey()), (Object)((Boolean)e.getValue()))).map(p -> Pair.of((Object)ArtifactVersionService.getArtifactVersion((String)p.getKey()), (Object)((Boolean)p.getValue())));
        Optional<Pair> upperBound = this.upperBounds.entrySet().stream().max(Map.Entry.comparingByKey()).map(e -> Pair.of((Object)((String)e.getKey()), (Object)((Boolean)e.getValue()))).map(p -> Pair.of((Object)ArtifactVersionService.getArtifactVersion((String)p.getKey()), (Object)((Boolean)p.getValue())));
        return (lowerBound.map(Pair::getValue).orElse(false) != false ? (char)'[' : '(') + lowerBound.map(Pair::getKey).map(Object::toString).orElse("") + ',' + upperBound.map(Pair::getKey).map(Object::toString).orElse("") + (upperBound.map(Pair::getValue).orElse(false) != false ? (char)']' : ')');
    }

    public PropertyVersionsBuilder withLowerBound(String lowerBound, boolean includeLower) {
        this.lowerBounds.compute(lowerBound, (__, oldValue) -> Optional.ofNullable(oldValue).orElse(true) != false && includeLower);
        return this;
    }

    public PropertyVersionsBuilder withUpperBound(String upperBound, boolean includeUpper) {
        this.upperBounds.compute(upperBound, (__, oldValue) -> Optional.ofNullable(oldValue).orElse(true) != false && includeUpper);
        return this;
    }

    public PropertyVersionsBuilder withCurrentVersion(ArtifactVersion currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    public PropertyVersionsBuilder withCurrentVersionRange(VersionRange currentVersionRange) {
        this.currentVersionRange = currentVersionRange;
        return this;
    }

    private SortedSet<ArtifactVersion> resolveAssociatedVersions(VersionsHelper helper, Set<ArtifactAssociation> associations) throws VersionRetrievalException {
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>();
        for (ArtifactAssociation association : associations) {
            ArtifactVersions artifactVersions = helper.lookupArtifactVersions(association.getArtifact(), association.isUsePluginRepositories());
            List<ArtifactVersion> associatedVersions = Arrays.asList(artifactVersions.getVersions(true));
            if (result.isEmpty()) {
                result.addAll(associatedVersions);
                continue;
            }
            result.retainAll(associatedVersions);
        }
        return result;
    }
}

