/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.rule;

import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.IgnoreVersionHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.rule.RuleService;

public class RuleServiceUtils {
    public static ArtifactVersions filterByRuleService(String groupId, String artifactId, ArtifactVersions artifactVersions, RuleService ruleService, Log log) {
        List<IgnoreVersion> ignoredVersions = ruleService.getIgnoredVersions(groupId, artifactId);
        String artifactKey = groupId + ":" + artifactId;
        if (!ignoredVersions.isEmpty() && log.isDebugEnabled()) {
            log.debug((CharSequence)("Found ignored versions: " + ignoredVersions + " for artifact " + artifactKey));
        }
        return new ArtifactVersions(artifactVersions).filter(version -> ignoredVersions.stream().noneMatch(i -> {
            if (IgnoreVersionHelper.isVersionIgnored(version, i)) {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Version " + version + " for artifact " + artifactKey + " found on ignore list: " + i));
                }
                return true;
            }
            return false;
        }));
    }
}

