/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.AbstractSingleWagonMojo;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.util.StringUtils;

public class UploadMojo
extends AbstractSingleWagonMojo {
    private File fromDir;
    private String excludes;
    private String includes;
    private boolean followSymLink = false;
    private boolean useDefaultExcludes = true;
    private String toDir = "";
    private boolean optimize = false;
    protected WagonUpload wagonUpload;

    protected void execute(Wagon wagon) throws WagonException, IOException {
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(this.fromDir.getAbsolutePath());
        if (!StringUtils.isBlank((String)this.includes)) {
            fileSet.setIncludes(Arrays.asList(StringUtils.split((String)this.includes, (String)",")));
        }
        if (!StringUtils.isBlank((String)this.excludes)) {
            fileSet.setExcludes(Arrays.asList(StringUtils.split((String)this.excludes, (String)",")));
        }
        fileSet.setFollowSymlinks(this.followSymLink);
        fileSet.setUseDefaultExcludes(this.useDefaultExcludes);
        fileSet.setOutputDirectory(this.toDir);
        this.wagonUpload.upload(wagon, fileSet, this.optimize, this.getLog());
    }
}

