/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.mojo.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.sonar.commons.ServerHttpClient;

public class BootstrapPomBuilder {
    private ServerHttpClient server;
    private static final String REPOSITORY__ID = "sonar-runtime";

    public BootstrapPomBuilder(ServerHttpClient server) {
        this.server = server;
    }

    public MavenProject build(ArtifactRepositoryFactory repoFactory, MavenProject project) throws IOException {
        return this.addInternalDependencies(repoFactory, project);
    }

    private MavenProject addInternalDependencies(ArtifactRepositoryFactory repoFactory, MavenProject project) throws IOException {
        this.checkIfInternalRepositoryIsAlreadyDefined(project);
        ArrayList<ArtifactRepository> pluginRepositories = new ArrayList<ArtifactRepository>();
        ArtifactRepository repository = repoFactory.createArtifactRepository(REPOSITORY__ID, this.server.getMavenRepositoryUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(false, "never", "ignore"), new ArtifactRepositoryPolicy(true, "never", "ignore"));
        pluginRepositories.add(repository);
        pluginRepositories.addAll(project.getPluginArtifactRepositories());
        project.setPluginArtifactRepositories(pluginRepositories);
        ArrayList<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        artifactRepositories.add(repository);
        artifactRepositories.addAll(project.getRemoteArtifactRepositories());
        project.setRemoteArtifactRepositories(artifactRepositories);
        return project;
    }

    private void checkIfInternalRepositoryIsAlreadyDefined(MavenProject project) {
        for (Repository repository : project.getRepositories()) {
            if (!REPOSITORY__ID.equals(repository.getId())) continue;
            throw new RuntimeException("Pom already defines a repository with id 'sonar-runtime', please remove it.");
        }
    }
}

