/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class EUnary
extends AExpression {
    private final Operation operation;
    private AExpression child;
    private Definition.Type promote;
    private boolean originallyExplicit = false;

    public EUnary(Location location, Operation operation, AExpression child) {
        super(location);
        this.operation = Objects.requireNonNull(operation);
        this.child = Objects.requireNonNull(child);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.child.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.originallyExplicit = this.explicit;
        if (this.operation == Operation.NOT) {
            this.analyzeNot(locals);
        } else if (this.operation == Operation.BWNOT) {
            this.analyzeBWNot(locals);
        } else if (this.operation == Operation.ADD) {
            this.analyzerAdd(locals);
        } else if (this.operation == Operation.SUB) {
            this.analyzerSub(locals);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
    }

    void analyzeNot(Locals variables) {
        this.child.expected = variables.getDefinition().booleanType;
        this.child.analyze(variables);
        this.child = this.child.cast(variables);
        if (this.child.constant != null) {
            this.constant = (Boolean)this.child.constant == false;
        }
        this.actual = variables.getDefinition().booleanType;
    }

    void analyzeBWNot(Locals variables) {
        this.child.analyze(variables);
        this.promote = variables.getDefinition().caster.promoteNumeric(this.child.actual, false);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply not [~] to type [" + this.child.actual.name + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(variables);
        if (this.child.constant != null) {
            Class<?> sort = this.promote.clazz;
            if (sort == Integer.TYPE) {
                this.constant = ~((Integer)this.child.constant).intValue();
            } else if (sort == Long.TYPE) {
                this.constant = (Long)this.child.constant ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote.dynamic && this.expected != null ? this.expected : this.promote;
    }

    void analyzerAdd(Locals variables) {
        this.child.analyze(variables);
        this.promote = variables.getDefinition().caster.promoteNumeric(this.child.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply positive [+] to type [" + this.child.actual.name + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(variables);
        if (this.child.constant != null) {
            Class<?> sort = this.promote.clazz;
            if (sort == Integer.TYPE) {
                this.constant = (int)((Integer)this.child.constant);
            } else if (sort == Long.TYPE) {
                this.constant = (long)((Long)this.child.constant);
            } else if (sort == Float.TYPE) {
                this.constant = Float.valueOf(((Float)this.child.constant).floatValue());
            } else if (sort == Double.TYPE) {
                this.constant = (double)((Double)this.child.constant);
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote.dynamic && this.expected != null ? this.expected : this.promote;
    }

    void analyzerSub(Locals variables) {
        this.child.analyze(variables);
        this.promote = variables.getDefinition().caster.promoteNumeric(this.child.actual, true);
        if (this.promote == null) {
            throw this.createError(new ClassCastException("Cannot apply negative [-] to type [" + this.child.actual.name + "]."));
        }
        this.child.expected = this.promote;
        this.child = this.child.cast(variables);
        if (this.child.constant != null) {
            Class<?> sort = this.promote.clazz;
            if (sort == Integer.TYPE) {
                this.constant = -((Integer)this.child.constant).intValue();
            } else if (sort == Long.TYPE) {
                this.constant = -((Long)this.child.constant).longValue();
            } else if (sort == Float.TYPE) {
                this.constant = Float.valueOf(-((Float)this.child.constant).floatValue());
            } else if (sort == Double.TYPE) {
                this.constant = -((Double)this.child.constant).doubleValue();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
        this.actual = this.promote.dynamic && this.expected != null ? this.expected : this.promote;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.operation == Operation.NOT) {
            Label fals = new Label();
            Label end = new Label();
            this.child.write(writer, globals);
            writer.ifZCmp(153, fals);
            writer.push(false);
            writer.goTo(end);
            writer.mark(fals);
            writer.push(true);
            writer.mark(end);
        } else {
            Class<?> sort = this.promote.clazz;
            this.child.write(writer, globals);
            int defFlags = 0;
            if (this.originallyExplicit) {
                defFlags |= 4;
            }
            if (this.operation == Operation.BWNOT) {
                if (this.promote.dynamic) {
                    Type descriptor = Type.getMethodType((Type)this.actual.type, (Type[])new Type[]{this.child.actual.type});
                    writer.invokeDefCall("not", descriptor, 7, defFlags);
                } else {
                    if (sort == Integer.TYPE) {
                        writer.push(-1);
                    } else if (sort == Long.TYPE) {
                        writer.push(-1L);
                    } else {
                        throw this.createError(new IllegalStateException("Illegal tree structure."));
                    }
                    writer.math(130, this.actual.type);
                }
            } else if (this.operation == Operation.SUB) {
                if (this.promote.dynamic) {
                    Type descriptor = Type.getMethodType((Type)this.actual.type, (Type[])new Type[]{this.child.actual.type});
                    writer.invokeDefCall("neg", descriptor, 7, defFlags);
                } else {
                    writer.math(116, this.actual.type);
                }
            } else if (this.operation == Operation.ADD) {
                if (this.promote.dynamic) {
                    Type descriptor = Type.getMethodType((Type)this.actual.type, (Type[])new Type[]{this.child.actual.type});
                    writer.invokeDefCall("plus", descriptor, 7, defFlags);
                }
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.operation.symbol, this.child);
    }
}

