/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompassSettings {
    private ConcurrentHashMap<String, Object> settings;
    private final Map<String, HashMap<String, CompassSettings>> groups = new ConcurrentHashMap<String, HashMap<String, CompassSettings>>();
    private Map<Object, Object> registry = new ConcurrentHashMap<Object, Object>();
    private ClassLoader classLoader;
    private CompassSettings gloablSettings;

    public CompassSettings() {
        this.settings = new ConcurrentHashMap();
    }

    public CompassSettings(ClassLoader classLoader) {
        this();
        this.classLoader = classLoader;
    }

    public CompassSettings(Map<String, Object> settings) {
        this();
        this.settings.putAll(settings);
    }

    public void setGlobalSettings(CompassSettings settings) {
        this.gloablSettings = settings;
    }

    public CompassSettings getGloablSettings() {
        if (this.gloablSettings == null) {
            return this;
        }
        return this.gloablSettings;
    }

    public void addSettings(Properties settings) {
        for (Map.Entry<Object, Object> entry : settings.entrySet()) {
            this.setSetting((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void addSettings(Map<String, Object> settings) {
        this.settings.putAll(settings);
    }

    public Map<String, Object> getUnderlyingMap() {
        return this.settings;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            properties.setProperty(entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }

    public void addSettings(CompassSettings settings) {
        this.settings.putAll(settings.settings);
        this.registry.putAll(settings.registry);
        if (this.gloablSettings != null && settings.gloablSettings != null) {
            this.gloablSettings.addSettings(settings.gloablSettings);
        }
    }

    public CompassSettings copy() {
        CompassSettings copySettings = new CompassSettings();
        copySettings.gloablSettings = this.gloablSettings;
        copySettings.settings.putAll(this.settings);
        copySettings.registry = new ConcurrentHashMap<Object, Object>(this.registry);
        copySettings.classLoader = this.classLoader;
        return copySettings;
    }

    public CompassSettings clear() {
        this.settings.clear();
        return this;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public ClassLoader getDirectClassLoader() {
        return this.classLoader;
    }

    public Collection keySet() {
        return this.settings.keySet();
    }

    public void removeSetting(String setting) {
        this.settings.remove(setting);
    }

    public String getSetting(String setting) {
        return (String)this.settings.get(setting);
    }

    public Object getSettingAsObject(String setting) {
        return this.settings.get(setting);
    }

    public String getSetting(String setting, String defaultValue) {
        String retVal = (String)this.settings.get(setting);
        if (retVal == null) {
            return defaultValue;
        }
        return retVal;
    }

    public Map<String, CompassSettings> getSettingGroups(String settingPrefix) {
        Map group;
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        if ((group = (Map)this.groups.get(settingPrefix)) != null) {
            return group;
        }
        HashMap<String, CompassSettings> map = new HashMap<String, CompassSettings>();
        for (String o : this.settings.keySet()) {
            String setting = o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                throw new ConfigurationException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            CompassSettings groupSettings = map.get(name);
            if (groupSettings == null) {
                groupSettings = new CompassSettings();
                groupSettings.setGlobalSettings(this.getGloablSettings());
                groupSettings.setClassLoader(this.getClassLoader());
                map.put(name, groupSettings);
            }
            groupSettings.setObjectSetting(value, this.getSettingAsObject(setting));
        }
        this.groups.put(settingPrefix, map);
        return map;
    }

    public float getSettingAsFloat(String setting, float defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Float.parseFloat(sValue);
    }

    public double getSettingAsDouble(String setting, double defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Double.parseDouble(sValue);
    }

    public int getSettingAsInt(String setting, int defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public long getSettingAsLong(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Long.parseLong(sValue);
    }

    public boolean getSettingAsBoolean(String setting, boolean defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(sValue);
    }

    public long getSettingAsTimeInSeconds(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        if (sValue.endsWith("S")) {
            throw new IllegalArgumentException("Expected time in seconds, does not support millis");
        }
        if (sValue.endsWith("millis")) {
            throw new IllegalArgumentException("Expected time in seconds, does not support millis");
        }
        if (sValue.endsWith("s")) {
            return (long)Double.parseDouble(sValue.substring(0, sValue.length() - 1));
        }
        if (sValue.endsWith("m")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0);
        }
        if (sValue.endsWith("H")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0 * 60.0);
        }
        return Long.parseLong(sValue);
    }

    public long getSettingAsTimeInMillis(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        if (sValue.endsWith("S")) {
            return Long.parseLong(sValue.substring(0, sValue.length() - 1));
        }
        if (sValue.endsWith("millis")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - "millis".length())) * 1000.0);
        }
        if (sValue.endsWith("s")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000.0);
        }
        if (sValue.endsWith("m")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0 * 1000.0);
        }
        if (sValue.endsWith("H")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0 * 60.0 * 1000.0);
        }
        return Long.parseLong(sValue);
    }

    public long getSettingAsBytes(String setting, long defaultValue) {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return defaultValue;
        }
        return CompassSettings.parseStringAsBytes(sValue);
    }

    public static long parseStringAsBytes(String sValue) {
        if (sValue.endsWith("b")) {
            return Long.parseLong(sValue.substring(0, sValue.length() - 1));
        }
        if (sValue.endsWith("k") || sValue.endsWith("K")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0);
        }
        if (sValue.endsWith("m") || sValue.endsWith("M")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0 * 1024.0);
        }
        if (sValue.endsWith("g") || sValue.endsWith("G")) {
            return (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1024.0 * 1024.0 * 1024.0);
        }
        return Long.parseLong(sValue);
    }

    public Class getSettingAsClass(String setting, Class clazz) throws ClassNotFoundException {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return clazz;
        }
        return ClassUtils.forName(sValue, this.getClassLoader());
    }

    public Class getSettingAsClass(String setting, Class clazz, ClassLoader classLoader) throws ClassNotFoundException {
        String sValue = this.getSetting(setting);
        if (sValue == null) {
            return clazz;
        }
        return ClassUtils.forName(sValue, classLoader);
    }

    public Object getSettingAsInstance(String setting) {
        return this.getSettingAsInstance(setting, null);
    }

    public Object getSettingAsInstance(String setting, String defaultClass) {
        Object instance;
        Object type = this.getSettingAsObject(setting);
        if (type == null) {
            if (defaultClass == null) {
                return null;
            }
            type = defaultClass;
        }
        if (type instanceof String) {
            try {
                instance = ClassUtils.forName((String)type, this.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to instantiate [" + type + "], please verify class type at setting [" + setting + "]", e);
            }
        } else {
            instance = type;
        }
        if (instance instanceof CompassConfigurable) {
            ((CompassConfigurable)instance).configure(this);
        }
        return instance;
    }

    public CompassSettings setSetting(String setting, String value) {
        if (value == null) {
            return this;
        }
        this.settings.put(setting, value);
        return this;
    }

    public CompassSettings setObjectSetting(String setting, Object value) {
        if (value == null) {
            return this;
        }
        this.settings.put(setting, value);
        return this;
    }

    public CompassSettings setBooleanSetting(String setting, boolean value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setFloatSetting(String setting, float value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setDoubleSetting(String setting, double value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setIntSetting(String setting, int value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setLongSetting(String setting, long value) {
        this.setSetting(setting, String.valueOf(value));
        return this;
    }

    public CompassSettings setTimeSetting(String setting, long value, TimeUnit timeUnit) {
        this.setLongSetting(setting, timeUnit.toMillis(value));
        return this;
    }

    public CompassSettings setClassSetting(String setting, Class clazz) {
        this.setSetting(setting, clazz.getName());
        return this;
    }

    public CompassSettings setGroupSettings(String settingPrefix, String groupName, String[] settings, Object[] values) {
        if (settings.length != values.length) {
            throw new IllegalArgumentException("The settings length must match the value length");
        }
        for (int i = 0; i < settings.length; ++i) {
            if (values[i] == null) continue;
            this.setObjectSetting(settingPrefix + "." + groupName + "." + settings[i], values[i]);
        }
        return this;
    }

    public Object getRegistry(Object key) {
        return this.registry.get(key);
    }

    public void setRegistry(Object key, Object value) {
        this.registry.put(key, value);
    }

    public Object removeRegistry(Object key) {
        return this.registry.remove(key);
    }

    public String toString() {
        return this.settings.toString();
    }
}

