/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.AbstractInputStreamConfigurationBuilder;
import org.compass.core.json.JsonArray;
import org.compass.core.json.JsonObject;
import org.compass.core.json.impl.DefaultJSONObject;
import org.compass.core.json.impl.DefaultJSONTokener;
import org.compass.core.util.CopyUtils;
import org.compass.core.util.SystemPropertyUtils;

public class JsonConfigurationBuilder
extends AbstractInputStreamConfigurationBuilder {
    private ArrayList<String> elements = new ArrayList();
    private StringBuilder sb = new StringBuilder();

    protected void doConfigure(InputStream is, String resourceName, CompassConfiguration config) throws ConfigurationException {
        String json;
        try {
            json = CopyUtils.copyToString(new InputStreamReader(is));
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to read json configuration from [" + resourceName + "]", e);
        }
        DefaultJSONObject jsonObject = new DefaultJSONObject(new DefaultJSONTokener(json));
        this.process(config, jsonObject);
    }

    private void process(CompassConfiguration config, Object element) {
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            Iterator<String> keyIt = jsonObject.keys();
            while (keyIt.hasNext()) {
                String key = keyIt.next();
                Object value = jsonObject.opt(key);
                if (value == null) continue;
                this.elements.add(key);
                this.process(config, value);
                this.elements.remove(this.elements.size() - 1);
            }
        } else if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object value = jsonArray.opt(i);
                if (value == null || jsonArray.isNull(i)) continue;
                this.process(config, value);
            }
        } else {
            int i;
            this.sb.setLength(0);
            for (i = 0; i < this.elements.size() - 1; ++i) {
                this.sb.append(this.elements.get(i)).append('.');
            }
            this.sb.append(this.elements.get(i));
            config.setSetting(this.sb.toString(), SystemPropertyUtils.resolvePlaceholders(element.toString()));
        }
    }
}

