/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.DateMathParser;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.FormatterFactory;
import org.compass.core.converter.basic.format.TextFormatFormatter;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class DateConverter
extends AbstractFormatConverter {
    public static final String DEFAULT_NOW_PREFIX = "now";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss-S-a";

    protected String doGetDefaultFormat() {
        return DEFAULT_DATE_FORMAT;
    }

    protected FormatterFactory doCreateFormatterFactory() {
        return new DateFormatter();
    }

    protected Object doFromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        try {
            if (str.toLowerCase().startsWith(DEFAULT_NOW_PREFIX)) {
                DateMathParser p = new DateMathParser(TimeZone.getDefault(), this.locale);
                return p.parseMath(str.substring(DEFAULT_NOW_PREFIX.length()));
            }
            for (int i = 0; i < this.formatters.length; ++i) {
                try {
                    return this.formatters[i].parse(str);
                }
                catch (ParseException e) {
                    continue;
                }
            }
            throw new ConversionException("Failed to parse date [" + str + "]");
        }
        catch (ParseException e) {
            throw new ConversionException("Failed to parse date [" + str + "]", e);
        }
    }

    protected String doToString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return this.formatters[0].format(o);
    }

    private static class DateFormatter
    implements FormatterFactory {
        private String format;
        private Locale locale;

        private DateFormatter() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Formatter create() {
            SimpleDateFormat dateFormat = this.locale != null ? new SimpleDateFormat(this.format, this.locale) : new SimpleDateFormat(this.format);
            dateFormat.setLenient(false);
            return new TextFormatFormatter(dateFormat);
        }
    }
}

