/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatConverter
extends AbstractNumberConverter<Float> {
    @Override
    protected Float defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return Float.valueOf(str);
    }

    @Override
    protected Float fromNumber(Number number) {
        return Float.valueOf(number.floatValue());
    }

    @Override
    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                float val = ((Number)obj).floatValue();
                return NumberUtils.float2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return Float.valueOf(NumberUtils.SortableStr2float(str));
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

