/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.extended;

import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.AbstractFormatConverter;
import org.compass.core.converter.basic.DateMathParser;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.FormatterFactory;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public class DataTimeConverter
extends AbstractFormatConverter {
    public static final String DEFAULT_NOW_PREFIX = "now";
    public static final String ISO = "iso";

    protected FormatterFactory doCreateFormatterFactory() {
        return new DataTimeFormatterFactory();
    }

    protected String doGetDefaultFormat() {
        return ISO;
    }

    protected Object doFromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        try {
            if (str.toLowerCase().startsWith(DEFAULT_NOW_PREFIX)) {
                DateMathParser p = new DateMathParser(TimeZone.getDefault(), this.locale);
                return p.parseMath(str.substring(DEFAULT_NOW_PREFIX.length()));
            }
            for (int i = 0; i < this.formatters.length; ++i) {
                try {
                    return this.formatters[i].parse(str);
                }
                catch (Exception e) {
                    continue;
                }
            }
            throw new ConversionException("Failed to parse date [" + str + "]");
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse date [" + str + "]", e);
        }
    }

    protected String doToString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return this.formatters[0].format(o);
    }

    private class DateTimeFormatter
    implements Formatter {
        private final org.joda.time.format.DateTimeFormatter formatter;

        private DateTimeFormatter(org.joda.time.format.DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public String format(Object obj) {
            return this.formatter.print((ReadableInstant)((DateTime)obj));
        }

        public Object parse(String str) throws ParseException {
            return this.formatter.parseDateTime(str);
        }

        public boolean isThreadSafe() {
            return true;
        }
    }

    private class DataTimeFormatterFactory
    implements FormatterFactory {
        private String format;
        private Locale locale;

        private DataTimeFormatterFactory() {
        }

        public void configure(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        public Formatter create() {
            if (DataTimeConverter.ISO.equalsIgnoreCase(this.format)) {
                return new DateTimeFormatter(ISODateTimeFormat.dateTime());
            }
            org.joda.time.format.DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.format);
            formatter = formatter.withLocale(this.locale);
            return new DateTimeFormatter(formatter);
        }
    }
}

