/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem.collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceCollection;
import org.compass.core.converter.mapping.osem.collection.LazyReferenceEntry;
import org.compass.core.spi.InternalCompassSession;

public class LazyReferenceList
extends AbstractList
implements LazyReferenceCollection {
    private InternalCompassSession session;
    private final ArrayList<LazyReferenceEntry> entries;
    private Object[] objects;
    private ArrayList objectList;
    private boolean fullyLoaded = false;

    public LazyReferenceList(InternalCompassSession session, int size) {
        this.session = session;
        this.entries = new ArrayList(size);
        this.objects = new Object[size];
    }

    public void addLazyEntry(LazyReferenceEntry entry) {
        this.entries.add(entry);
    }

    public Object get(int index) {
        if (this.fullyLoaded) {
            return this.objectList.get(index);
        }
        Object obj = this.objects[index];
        if (obj == null) {
            this.objects[index] = obj = this.session.get(this.entries.get(index).getAlias(), this.entries.get(index).getIds());
        }
        return obj;
    }

    public int size() {
        if (this.fullyLoaded) {
            return this.objectList.size();
        }
        return this.entries.size();
    }

    public void add(int index, Object element) {
        this.loadFully();
        this.objectList.add(index, element);
    }

    public Object remove(int index) {
        this.loadFully();
        return this.objectList.remove(index);
    }

    public boolean add(Object o) {
        this.loadFully();
        return this.objectList.add(o);
    }

    public Object set(int index, Object element) {
        this.loadFully();
        return this.objectList.set(index, element);
    }

    public int indexOf(Object o) {
        if (this.fullyLoaded) {
            return this.objectList.indexOf(o);
        }
        return super.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        if (this.fullyLoaded) {
            return this.objectList.lastIndexOf(o);
        }
        return super.lastIndexOf(o);
    }

    public void clear() {
        this.fullyLoaded = true;
        if (this.objectList != null) {
            this.objectList.clear();
        } else {
            this.objectList = new ArrayList();
        }
    }

    public boolean addAll(int index, Collection c) {
        this.loadFully();
        return this.objectList.addAll(index, c);
    }

    public boolean contains(Object o) {
        if (this.fullyLoaded) {
            return this.objectList.contains(o);
        }
        return super.contains(o);
    }

    public boolean remove(Object o) {
        this.loadFully();
        return this.objectList.remove(o);
    }

    public Object[] toArray() {
        if (this.fullyLoaded) {
            return this.objectList.toArray();
        }
        return super.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.fullyLoaded) {
            return this.objectList.toArray(a);
        }
        return super.toArray(a);
    }

    public boolean containsAll(Collection c) {
        if (this.fullyLoaded) {
            return this.objectList.containsAll(c);
        }
        return super.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.loadFully();
        return this.objectList.addAll(c);
    }

    public boolean removeAll(Collection c) {
        this.loadFully();
        return this.objectList.removeAll(c);
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void loadFully() {
        if (this.fullyLoaded) {
            return;
        }
        this.objectList = new ArrayList(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            this.objectList.add(it.next());
        }
        this.objects = null;
        this.entries.clear();
        this.fullyLoaded = true;
    }
}

