/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassAnalyzerHelper;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.CompassQueryFilterBuilder;
import org.compass.core.CompassSession;
import org.compass.core.CompassTermFreqsBuilder;
import org.compass.core.CompassTransaction;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.NullFirstLevelCache;
import org.compass.core.cascade.CascadingManager;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.events.FilterOperation;
import org.compass.core.impl.DefaultCompassAnalyzerHelper;
import org.compass.core.impl.DefaultCompassQueryBuilder;
import org.compass.core.impl.DefaultCompassTermFreqsBuilder;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.marshall.DefaultMarshallingStrategy;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingException;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.DirtyOperationContext;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.InternalSessionDelegateClose;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.LocalTransaction;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompassSession
implements InternalCompassSession {
    private static final Log logger = LogFactory.getLog(DefaultCompassSession.class);
    private final InternalCompass compass;
    private final CompassMapping mapping;
    private final CompassMetaData compassMetaData;
    private final SearchEngine searchEngine;
    private final TransactionFactory transactionFactory;
    private final LocalTransactionFactory localTransactionFactory;
    private final MarshallingStrategy marshallingStrategy;
    private FirstLevelCache firstLevelCache;
    private volatile boolean closed = false;
    private final RuntimeCompassSettings runtimeSettings;
    private final CascadingManager cascadingManager;
    private boolean localTransaction;
    private volatile CompassTransaction transaction;
    private final List<InternalSessionDelegateClose> delegateClose = new ArrayList<InternalSessionDelegateClose>();
    private boolean rolledback;

    public DefaultCompassSession(RuntimeCompassSettings runtimeSettings, InternalCompass compass, SearchEngine searchEngine, FirstLevelCache firstLevelCache) {
        this.compass = compass;
        this.mapping = compass.getMapping();
        this.compassMetaData = compass.getMetaData();
        this.transactionFactory = compass.getTransactionFactory();
        this.localTransactionFactory = compass.getLocalTransactionFactory();
        this.runtimeSettings = runtimeSettings;
        this.searchEngine = searchEngine;
        this.firstLevelCache = firstLevelCache;
        this.marshallingStrategy = new DefaultMarshallingStrategy(this.mapping, searchEngine, compass.getConverterLookup(), this);
        this.cascadingManager = new CascadingManager(this);
        this.transaction = this.transactionFactory.tryJoinExistingTransaction(this);
    }

    @Override
    public ResourceFactory resourceFactory() {
        return this.compass.getResourceFactory();
    }

    @Override
    public CompassSettings getSettings() {
        return this.runtimeSettings;
    }

    @Override
    public void setReadOnly() {
        this.searchEngine.setReadOnly();
    }

    @Override
    public boolean isReadOnly() {
        return this.searchEngine.isReadOnly();
    }

    @Override
    public CompassQueryBuilder queryBuilder() throws CompassException {
        this.checkClosed();
        SearchEngineQueryBuilder searchEngineQueryBuilder = this.searchEngine.queryBuilder();
        return new DefaultCompassQueryBuilder(searchEngineQueryBuilder, this.compass, this);
    }

    @Override
    public CompassQueryFilterBuilder queryFilterBuilder() throws CompassException {
        this.checkClosed();
        return this.compass.queryFilterBuilder();
    }

    @Override
    public CompassTermFreqsBuilder termFreqsBuilder(String ... names) throws CompassException {
        this.checkClosed();
        return new DefaultCompassTermFreqsBuilder(this, names);
    }

    @Override
    public CompassAnalyzerHelper analyzerHelper() throws CompassException {
        this.checkClosed();
        SearchEngineAnalyzerHelper analyzerHelper = this.searchEngine.analyzerHelper();
        return new DefaultCompassAnalyzerHelper(analyzerHelper, this);
    }

    @Override
    public CompassSession useLocalTransaction() {
        if (this.transaction != null && !(this.transaction instanceof LocalTransaction)) {
            throw new IllegalStateException("There is already a transaction bounded to this session, and it is not a local one");
        }
        this.localTransaction = true;
        return this;
    }

    @Override
    public CompassTransaction beginTransaction() throws CompassException {
        this.checkClosed();
        if ("lucene".equalsIgnoreCase(this.getSettings().getSetting("compass.transaction.processor"))) {
            this.firstLevelCache = NullFirstLevelCache.INSTANCE;
        }
        this.transaction = this.transactionFactory.beginTransaction(this);
        return this.transaction;
    }

    @Override
    public CompassTransaction beginLocalTransaction() throws CompassException {
        this.checkClosed();
        if ("lucene".equalsIgnoreCase(this.getSettings().getSetting("compass.transaction.processor"))) {
            this.firstLevelCache = new NullFirstLevelCache();
        }
        this.transaction = this.localTransactionFactory.beginTransaction(this);
        return this.transaction;
    }

    @Override
    public void flush() throws CompassException {
        this.checkClosed();
        this.searchEngine.flush();
    }

    @Override
    public void flushCommit(String ... aliases) throws CompassException {
        this.checkClosed();
        this.searchEngine.flushCommit(aliases);
    }

    @Override
    public Resource getResource(Class clazz, Object ... ids) throws CompassException {
        return this.getResource(clazz, (Object)ids);
    }

    @Override
    public Resource getResource(Class clazz, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, id);
        if (idResource == null) {
            return null;
        }
        return this.getResourceByIdResource(idResource);
    }

    @Override
    public Resource getResource(String alias, Object ... ids) throws CompassException {
        return this.getResource(alias, (Object)ids);
    }

    @Override
    public Resource getResource(String alias, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        if (idResource == null) {
            return null;
        }
        return this.getResourceByIdResource(idResource);
    }

    @Override
    public Resource getResourceByIdResource(Resource idResource) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        ResourceKey key = ((InternalResource)idResource).getResourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.get(idResource);
        if (value != null) {
            this.firstLevelCache.setResource(key, value);
        }
        return value;
    }

    @Override
    public Resource getResourceByIdResourceNoCache(Resource idResource) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        return this.searchEngine.get(idResource);
    }

    @Override
    public <T> T get(Class<T> clazz, Object ... ids) throws CompassException {
        return this.get(clazz, (Object)ids);
    }

    @Override
    public <T> T get(Class<T> clazz, Object id) throws CompassException {
        Resource resource = this.getResource((Class)clazz, id);
        if (resource == null) {
            return null;
        }
        return (T)this.getByResource(resource);
    }

    @Override
    public Object get(String alias, Object ... ids) throws CompassException {
        return this.get(alias, (Object)ids);
    }

    @Override
    public Object get(String alias, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource);
    }

    @Override
    public Object get(String alias, Object id, MarshallingContext context) throws CompassException {
        this.checkClosed();
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource, context);
    }

    @Override
    public Object getByResource(Resource resource) {
        this.checkClosed();
        return this.getByResource(resource, null);
    }

    public Object getByResource(Resource resource, MarshallingContext context) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        ResourceKey key = ((InternalResource)resource).getResourceKey();
        Object cachedValue = this.firstLevelCache.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Object value = context == null ? this.marshallingStrategy.unmarshall(resource) : this.marshallingStrategy.unmarshall(resource, context);
        this.firstLevelCache.set(key, value);
        return value;
    }

    @Override
    public Resource loadResource(Class clazz, Object ... ids) throws CompassException {
        return this.loadResource(clazz, (Object)ids);
    }

    @Override
    public Resource loadResource(Class clazz, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, id);
        return this.loadResourceByIdResource(idResource);
    }

    @Override
    public Resource loadResource(String alias, Object ... ids) throws CompassException {
        return this.loadResource(alias, (Object)ids);
    }

    @Override
    public Resource loadResource(String alias, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        return this.loadResourceByIdResource(idResource);
    }

    public Resource loadResourceByIdResource(Resource idResource) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        ResourceKey key = ((InternalResource)idResource).getResourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.load(idResource);
        this.firstLevelCache.setResource(key, value);
        return value;
    }

    @Override
    public <T> T load(Class<T> clazz, Object ... ids) throws CompassException {
        return this.load(clazz, (Object)ids);
    }

    @Override
    public <T> T load(Class<T> clazz, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource resource = this.loadResource((Class)clazz, id);
        return (T)this.getByResource(resource);
    }

    @Override
    public Object load(String alias, Object ... ids) throws CompassException {
        return this.load(alias, (Object)ids);
    }

    @Override
    public Object load(String alias, Object id) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource resource = this.loadResource(alias, id);
        return this.getByResource(resource);
    }

    @Override
    public CompassHits find(String query) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        return this.queryBuilder().queryString(query).toQuery().hits();
    }

    @Override
    public void create(String alias, Object object) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.create(alias, object, new DirtyOperationContext());
    }

    @Override
    public void create(String alias, Object object, DirtyOperationContext context) throws CompassException {
        if (context.alreadyPerformedOperation(object)) {
            return;
        }
        if (this.compass.getEventManager().onPreCreate(alias, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreCreate(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.create(resource);
            ResourceKey key = ((InternalResource)resource).getResourceKey();
            this.firstLevelCache.set(key, object);
            this.firstLevelCache.setResource(key, resource);
        }
        context.addOperatedObjects(object);
        boolean performedCascading = this.cascadingManager.cascade(alias, object, Cascade.CREATE, context);
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostCreate(resource);
        }
        this.compass.getEventManager().onPostCreate(alias, object);
    }

    @Override
    public void create(Object object) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.create(object, new DirtyOperationContext());
    }

    @Override
    public void create(Object object, DirtyOperationContext context) throws CompassException {
        boolean performedCascading;
        if (context.alreadyPerformedOperation(object)) {
            return;
        }
        if (this.compass.getEventManager().onPreCreate(null, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreCreate(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.create(resource);
            ResourceKey key = ((InternalResource)resource).getResourceKey();
            this.firstLevelCache.set(key, object);
            this.firstLevelCache.setResource(key, resource);
            context.addOperatedObjects(object);
            performedCascading = this.cascadingManager.cascade(key.getAlias(), object, Cascade.CREATE, context);
        } else {
            context.addOperatedObjects(object);
            performedCascading = this.cascadingManager.cascade(object, Cascade.CREATE, context);
        }
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Object [" + object.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostCreate(resource);
            this.compass.getEventManager().onPostCreate(resource.getAlias(), object);
        } else {
            this.compass.getEventManager().onPostCreate(null, object);
        }
    }

    @Override
    public void save(String alias, Object object) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.save(alias, object, new DirtyOperationContext());
    }

    @Override
    public void save(String alias, Object object, DirtyOperationContext context) throws CompassException {
        if (context.alreadyPerformedOperation(object)) {
            return;
        }
        if (this.compass.getEventManager().onPreSave(alias, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreSave(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.save(resource);
            ResourceKey key = ((InternalResource)resource).getResourceKey();
            this.firstLevelCache.set(key, object);
            this.firstLevelCache.setResource(key, resource);
        }
        context.addOperatedObjects(object);
        boolean performedCascading = this.cascadingManager.cascade(alias, object, Cascade.SAVE, context);
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostSave(resource);
        }
        this.compass.getEventManager().onPostSave(alias, object);
    }

    @Override
    public void save(Object object) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.save(object, new DirtyOperationContext());
    }

    @Override
    public void save(Object object, DirtyOperationContext context) throws CompassException {
        boolean performedCascading;
        if (context.alreadyPerformedOperation(object)) {
            return;
        }
        if (this.compass.getEventManager().onPreSave(null, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreSave(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.save(resource);
            ResourceKey key = ((InternalResource)resource).getResourceKey();
            this.firstLevelCache.setResource(key, resource);
            this.firstLevelCache.set(key, object);
            context.addOperatedObjects(object);
            performedCascading = this.cascadingManager.cascade(key.getAlias(), object, Cascade.SAVE, context);
        } else {
            context.addOperatedObjects(object);
            performedCascading = this.cascadingManager.cascade(object, Cascade.SAVE, context);
        }
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Object [" + object.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostSave(resource);
            this.compass.getEventManager().onPostSave(resource.getAlias(), object);
        } else {
            this.compass.getEventManager().onPostSave(null, object);
        }
    }

    @Override
    public void delete(String alias, Object ... ids) throws CompassException {
        this.delete(alias, (Object)ids);
    }

    @Override
    public void delete(String alias, Object obj) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.delete(alias, obj, new DirtyOperationContext());
    }

    @Override
    public void delete(String alias, Object obj, DirtyOperationContext context) throws CompassException {
        if (context.alreadyPerformedOperation(obj)) {
            return;
        }
        if (this.compass.getEventManager().onPreDelete(alias, obj) == FilterOperation.YES) {
            return;
        }
        boolean performedCascading = false;
        Resource idResource = this.marshallingStrategy.marshallIds(alias, obj);
        if (idResource != null) {
            Resource resouce;
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            Object cascadeObj = null;
            if (this.cascadingManager.shouldCascade(idResource.getAlias(), obj, Cascade.DELETE) && (resouce = this.getResourceByIdResource(idResource)) != null) {
                cascadeObj = this.getByResource(resouce);
            }
            this.delete(idResource);
            if (cascadeObj != null) {
                context.addOperatedObjects(cascadeObj);
                performedCascading = this.cascadingManager.cascade(idResource.getAlias(), cascadeObj, Cascade.DELETE, context);
            }
        } else {
            context.addOperatedObjects(obj);
            performedCascading = this.cascadingManager.cascade(alias, obj, Cascade.DELETE, context);
        }
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
        }
        this.compass.getEventManager().onPostDelete(alias, obj);
    }

    @Override
    public void delete(Class clazz, Object ... ids) throws CompassException {
        this.delete(clazz, (Object)ids);
    }

    @Override
    public void delete(Class clazz, Object obj) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.delete(clazz, obj, new DirtyOperationContext());
    }

    @Override
    public void delete(Class clazz, Object obj, DirtyOperationContext context) throws CompassException {
        if (context.alreadyPerformedOperation(obj)) {
            return;
        }
        if (this.compass.getEventManager().onPreDelete(clazz, obj) == FilterOperation.YES) {
            return;
        }
        boolean performedCascading = false;
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, obj);
        if (idResource != null) {
            Resource resouce;
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            Object cascadeObj = null;
            if (this.cascadingManager.shouldCascade(idResource.getAlias(), obj, Cascade.DELETE) && (resouce = this.getResourceByIdResource(idResource)) != null) {
                cascadeObj = this.getByResource(resouce);
            }
            this.delete(idResource);
            if (cascadeObj != null) {
                context.addOperatedObjects(cascadeObj);
                performedCascading = this.cascadingManager.cascade(idResource.getAlias(), cascadeObj, Cascade.DELETE, context);
            }
        } else {
            context.addOperatedObjects(obj);
            performedCascading = this.cascadingManager.cascade(clazz, obj, Cascade.DELETE, context);
        }
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Object [" + clazz + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
            this.compass.getEventManager().onPostDelete(idResource.getAlias(), obj);
        } else {
            this.compass.getEventManager().onPostDelete(clazz, obj);
        }
    }

    @Override
    public void delete(Object obj) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.delete(obj, new DirtyOperationContext());
    }

    @Override
    public void delete(Object obj, DirtyOperationContext context) throws CompassException {
        if (context.alreadyPerformedOperation(obj)) {
            return;
        }
        if (this.compass.getEventManager().onPreDelete((String)null, obj) == FilterOperation.YES) {
            return;
        }
        boolean performedCascading = false;
        Resource idResource = this.marshallingStrategy.marshallIds(obj);
        if (idResource != null) {
            Resource resouce;
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            Object cascadeObj = null;
            if (this.cascadingManager.shouldCascade(idResource.getAlias(), obj, Cascade.DELETE) && (resouce = this.getResourceByIdResource(idResource)) != null) {
                cascadeObj = this.getByResource(resouce);
            }
            this.delete(idResource);
            if (cascadeObj != null) {
                context.addOperatedObjects(cascadeObj);
                performedCascading = this.cascadingManager.cascade(idResource.getAlias(), cascadeObj, Cascade.DELETE, context);
            }
        } else {
            context.addOperatedObjects(obj);
            performedCascading = this.cascadingManager.cascade(obj, Cascade.DELETE, context);
        }
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Object [" + obj.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
            this.compass.getEventManager().onPostDelete(idResource.getAlias(), obj);
        } else {
            this.compass.getEventManager().onPostDelete((String)null, obj);
        }
    }

    @Override
    public void delete(Resource resource) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        this.firstLevelCache.evict(((InternalResource)resource).getResourceKey());
        if (this.compass.getEventManager().onPreDelete(resource) == FilterOperation.YES) {
            return;
        }
        this.searchEngine.delete(resource);
        this.compass.getEventManager().onPostDelete(resource);
    }

    @Override
    public void delete(CompassQuery query) throws CompassException {
        this.checkClosed();
        this.startTransactionIfNeeded();
        query.delete();
    }

    @Override
    public void evict(Object obj) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(obj.getClass(), obj);
        ResourceKey key = ((InternalResource)idResource).getResourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evict(String alias, Object id) {
        this.checkClosed();
        this.startTransactionIfNeeded();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        ResourceKey key = ((InternalResource)idResource).getResourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evict(Resource resource) {
        this.checkClosed();
        ResourceKey key = ((InternalResource)resource).getResourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evictAll() {
        this.checkClosed();
        this.firstLevelCache.evictAll();
    }

    @Override
    public void addDelegateClose(InternalSessionDelegateClose delegateClose) {
        this.delegateClose.add(delegateClose);
    }

    @Override
    public void unbindTransaction() {
        this.transaction = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws CompassException {
        try {
            if (this.transaction != null) {
                this.rolledback = true;
                this.transaction.rollback();
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws CompassException {
        try {
            if (this.transaction != null) {
                this.transaction.commit();
                this.transaction = null;
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws CompassException {
        CompassSession transactionBoundSession;
        if (this.closed) {
            return;
        }
        for (InternalSessionDelegateClose delegateClose : this.delegateClose) {
            delegateClose.close();
        }
        CompassException ex = null;
        if (this.transaction != null) {
            try {
                this.transaction.commit();
            }
            catch (CompassException e) {
                ex = e;
                try {
                    this.transaction.rollback();
                }
                catch (Exception e1) {
                    logger.warn((Object)"Failed to rollback transaction after auto commit on session close, ignoring", (Throwable)e);
                }
            }
        }
        if ((transactionBoundSession = this.transactionFactory.getTransactionBoundSession()) == null || transactionBoundSession != this) {
            this.closed = true;
            if (this.transaction != null && !this.rolledback) {
                logger.warn((Object)"Session close without being committed / rolledback, rolling back the transaction");
                try {
                    this.transaction.rollback();
                }
                catch (CompassException e) {
                    logger.debug((Object)"Failed to rollback un-committed transaction", (Throwable)e);
                }
            }
            this.firstLevelCache.evictAll();
            this.searchEngine.close();
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public InternalCompass getCompass() {
        return this.compass;
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public MarshallingStrategy getMarshallingStrategy() {
        return this.marshallingStrategy;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public CompassMapping getMapping() {
        return this.mapping;
    }

    @Override
    public CompassMetaData getMetaData() {
        return this.compassMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTransactionIfNeeded() {
        if (this.rolledback) {
            throw new CompassException("Transaction already rolled back");
        }
        if (this.transaction == null) {
            DefaultCompassSession defaultCompassSession = this;
            synchronized (defaultCompassSession) {
                if (this.transaction == null) {
                    this.transaction = this.localTransaction ? this.beginLocalTransaction() : this.beginTransaction();
                }
            }
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("CompassSession already closed");
        }
    }
}

