/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.IndexHoldersCache;
import org.compass.core.lucene.engine.manager.IndexWritersManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.transaction.context.TransactionContextCallback;

public class DefaultLuceneSearchEngineIndexManager
implements LuceneSearchEngineIndexManager {
    private static Log log = LogFactory.getLog(DefaultLuceneSearchEngineIndexManager.class);
    private final LuceneSearchEngineFactory searchEngineFactory;
    private final LuceneSearchEngineStore searchEngineStore;
    private final LuceneSettings luceneSettings;
    private final IndexHoldersCache indexHoldersCache;
    private final IndexWritersManager indexWritersManager;
    private long waitForCacheInvalidationBeforeSecondStep = 0L;
    private volatile boolean isRunning = false;
    private ScheduledFuture scheduledIndexManagerFuture;

    public DefaultLuceneSearchEngineIndexManager(LuceneSearchEngineFactory searchEngineFactory, LuceneSearchEngineStore searchEngineStore) {
        this.searchEngineFactory = searchEngineFactory;
        this.searchEngineStore = searchEngineStore;
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
        this.indexHoldersCache = new IndexHoldersCache(this);
        this.indexWritersManager = new IndexWritersManager(this);
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        long indexManagerScheduleInterval = this.luceneSettings.getSettings().getSettingAsTimeInMillis("compass.engine.indexManagerScheduleInterval", 60000L);
        if (indexManagerScheduleInterval > 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting scheduled index manager with period [" + indexManagerScheduleInterval + "ms]"));
            }
        } else {
            log.info((Object)"Not starting scheduled index manager");
            return;
        }
        ScheduledIndexManagerRunnable scheduledIndexManagerRunnable = new ScheduledIndexManagerRunnable(this);
        this.scheduledIndexManagerFuture = this.searchEngineFactory.getExecutorManager().scheduleWithFixedDelay(scheduledIndexManagerRunnable, indexManagerScheduleInterval, indexManagerScheduleInterval, TimeUnit.MILLISECONDS);
        this.setWaitForCacheInvalidationBeforeSecondStep((long)((double)indexManagerScheduleInterval * 1.1));
        this.indexHoldersCache.start();
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.scheduledIndexManagerFuture != null) {
            this.scheduledIndexManagerFuture.cancel(true);
            this.scheduledIndexManagerFuture = null;
        }
        this.indexHoldersCache.stop();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void createIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating index " + this.searchEngineStore));
        }
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.clearCache();
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.createIndex();
                return null;
            }
        });
    }

    public void deleteIndex() throws SearchEngineException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting index " + this.searchEngineStore));
        }
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.clearCache();
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.deleteIndex();
                return null;
            }
        });
    }

    public void cleanIndex() throws SearchEngineException {
        for (String subIndex : this.getSubIndexes()) {
            this.cleanIndex(subIndex);
        }
    }

    public void cleanIndex(final String subIndex) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.doUnderCacheLock(subIndex, new Runnable(){

                    public void run() {
                        DefaultLuceneSearchEngineIndexManager.this.clearCache(subIndex);
                        DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.cleanIndex(subIndex);
                    }
                });
                return null;
            }
        });
    }

    public boolean verifyIndex() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.clearCache();
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.verifyIndex();
            }
        });
    }

    public boolean indexExists() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.indexExists();
            }
        });
    }

    public void operate(SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        this.doOperate(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOperate(SearchEngineIndexManager.IndexOperationCallback callback) throws SearchEngineException {
        Lock[] writerLocks;
        block12: {
            String[] subIndexes = this.searchEngineStore.getSubIndexes();
            if (callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                SearchEngineIndexManager.IndexOperationPlan plan = (SearchEngineIndexManager.IndexOperationPlan)((Object)callback);
                subIndexes = this.searchEngineStore.polyCalcSubIndexes(plan.getSubIndexes(), plan.getAliases(), plan.getTypes());
            }
            writerLocks = new Lock[subIndexes.length];
            try {
                boolean continueToSecondStep;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to obtain write locks");
                }
                final String[] finalSubIndexes = subIndexes;
                this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

                    @Override
                    public Object doInTransaction() throws CompassException {
                        for (int i = 0; i < finalSubIndexes.length; ++i) {
                            Directory dir = DefaultLuceneSearchEngineIndexManager.this.getDirectory(finalSubIndexes[i]);
                            writerLocks[i] = dir.makeLock("write.lock");
                            try {
                                writerLocks[i].obtain(DefaultLuceneSearchEngineIndexManager.this.luceneSettings.getTransactionLockTimout());
                                continue;
                            }
                            catch (IOException e) {
                                throw new SearchEngineException("Failed to retrieve transaction locks", e);
                            }
                        }
                        return null;
                    }
                });
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Obtained write locks");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Calling callback first step");
                }
                if (continueToSecondStep = callback.firstStep()) break block12;
            }
            catch (Throwable throwable) {
                this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(writerLocks){
                    final /* synthetic */ Lock[] val$writerLocks;
                    {
                        this.val$writerLocks = lockArray;
                    }

                    @Override
                    public Object doInTransaction() throws CompassException {
                        LuceneUtils.clearLocks(this.val$writerLocks);
                        return null;
                    }
                });
                throw throwable;
            }
            this.searchEngineFactory.getTransactionContext().execute(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        this.clearCache();
        this.notifyAllToClearCache();
        if (this.waitForCacheInvalidationBeforeSecondStep != 0L && this.luceneSettings.isWaitForCacheInvalidationOnIndexOperation()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting [" + this.waitForCacheInvalidationBeforeSecondStep + "ms] for global cache invalidation"));
                }
                Thread.sleep(this.waitForCacheInvalidationBeforeSecondStep);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Interrupted while waiting for cache invalidation", (Throwable)e);
                throw new SearchEngineException("Interrupted while waiting for cache invalidation", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Calling callback second step");
        }
        callback.secondStep();
        this.searchEngineFactory.getTransactionContext().execute(new /* invalid duplicate definition of identical inner class */);
    }

    public void replaceIndex(SearchEngineIndexManager indexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        this.doReplaceIndex(indexManager, callback);
    }

    protected void doReplaceIndex(SearchEngineIndexManager indexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) throws SearchEngineException {
        LuceneSearchEngineIndexManager luceneIndexManager = (LuceneSearchEngineIndexManager)indexManager;
        this.doOperate(new ReplaceIndexOperationCallback(luceneIndexManager, callback));
    }

    public synchronized void close() {
        this.stop();
        this.clearCache();
        this.indexHoldersCache.close();
        this.indexWritersManager.close();
        this.searchEngineStore.close();
    }

    public boolean isCached(String subIndex) throws SearchEngineException {
        return this.indexHoldersCache.isCached(subIndex);
    }

    public boolean isCached() throws SearchEngineException {
        return this.indexHoldersCache.isCached();
    }

    public void clearCache(String subIndex) throws SearchEngineException {
        this.indexHoldersCache.clearCache(subIndex);
    }

    public void clearCache() throws SearchEngineException {
        this.indexHoldersCache.clearCache();
    }

    public void invalidateCache(String subIndex) throws SearchEngineException {
        this.indexHoldersCache.invalidateCache(subIndex);
    }

    public void invalidateCache() throws SearchEngineException {
        this.indexHoldersCache.invalidateCache();
    }

    public void refreshCache(final String subIndex) throws SearchEngineException {
        this.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.refreshCache(subIndex);
                return null;
            }
        });
    }

    public void refreshCache() throws SearchEngineException {
        this.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.refreshCache();
                return null;
            }
        });
    }

    public void notifyAllToClearCache() throws SearchEngineException {
        this.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.notifyAllToClearCache();
                return null;
            }
        });
    }

    public void checkAndClearIfNotifiedAllToClearCache() throws SearchEngineException {
        this.indexHoldersCache.checkAndClearIfNotifiedAllToClearCache();
    }

    public IndexSearcher openIndexSearcher(IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity(this.searchEngineFactory.getSimilarityManager().getSearchSimilarity());
        return searcher;
    }

    public MultiSearcher openMultiSearcher(Searchable[] searchers) throws IOException {
        MultiSearcher searcher = new MultiSearcher(searchers);
        searcher.setSimilarity(this.searchEngineFactory.getSimilarityManager().getSearchSimilarity());
        return searcher;
    }

    public LuceneSearchEngineStore getStore() {
        return this.searchEngineStore;
    }

    public IndexHoldersCache getIndexHoldersCache() {
        return this.indexHoldersCache;
    }

    public IndexWritersManager getIndexWritersManager() {
        return this.indexWritersManager;
    }

    public Directory getDirectory(String subIndex) {
        return this.searchEngineStore.openDirectory(subIndex);
    }

    public void performScheduledTasks() throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.checkAndClearIfNotifiedAllToClearCache();
                DefaultLuceneSearchEngineIndexManager.this.getStore().performScheduledTasks();
                return null;
            }
        });
    }

    public String[] getSubIndexes() {
        return this.searchEngineStore.getSubIndexes();
    }

    public boolean subIndexExists(String subIndex) {
        return this.searchEngineStore.subIndexExists(subIndex);
    }

    public boolean isLocked() throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.isLocked();
            }
        });
    }

    public boolean isLocked(final String subIndex) throws SearchEngineException {
        return this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Boolean>(){

            @Override
            public Boolean doInTransaction() throws CompassException {
                return DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.isLocked(subIndex);
            }
        });
    }

    public void releaseLocks() throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.releaseLocks();
                return null;
            }
        });
    }

    public void releaseLock(final String subIndex) throws SearchEngineException {
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.releaseLock(subIndex);
                return null;
            }
        });
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.searchEngineStore.calcSubIndexes(subIndexes, aliases, types);
    }

    public String[] polyCalcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.searchEngineStore.polyCalcSubIndexes(subIndexes, aliases, types);
    }

    public boolean requiresAsyncTransactionalContext() {
        return this.searchEngineStore.requiresAsyncTransactionalContext();
    }

    public boolean supportsConcurrentOperations() {
        return this.searchEngineStore.supportsConcurrentOperations();
    }

    public boolean supportsConcurrentCommits() {
        return this.searchEngineStore.supportsConcurrentCommits();
    }

    public void setWaitForCacheInvalidationBeforeSecondStep(long timeToWaitInMillis) {
        this.waitForCacheInvalidationBeforeSecondStep = timeToWaitInMillis;
    }

    public LuceneSettings getSettings() {
        return this.luceneSettings;
    }

    public ExecutorManager getExecutorManager() {
        return this.searchEngineFactory.getExecutorManager();
    }

    public TransactionContext getTransactionContext() {
        return this.searchEngineFactory.getTransactionContext();
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    private static class ScheduledIndexManagerRunnable
    implements Runnable {
        private LuceneSearchEngineIndexManager indexManager;

        public ScheduledIndexManagerRunnable(LuceneSearchEngineIndexManager indexManager) {
            this.indexManager = indexManager;
        }

        public void run() {
            block2: {
                try {
                    this.indexManager.performScheduledTasks();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug((Object)"Failed to perform schedule task", (Throwable)e);
                }
            }
        }
    }

    private final class ReplaceIndexOperationCallback
    implements SearchEngineIndexManager.IndexOperationCallback,
    SearchEngineIndexManager.IndexOperationPlan {
        private SearchEngineIndexManager.ReplaceIndexCallback callback;
        private LuceneSearchEngineIndexManager indexManager;

        private ReplaceIndexOperationCallback(LuceneSearchEngineIndexManager indexManager, SearchEngineIndexManager.ReplaceIndexCallback callback) {
            this.indexManager = indexManager;
            this.callback = callback;
        }

        public boolean firstStep() throws SearchEngineException {
            this.callback.buildIndexIfNeeded();
            return true;
        }

        public void secondStep() throws SearchEngineException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Replace Index] Replacing index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] with [" + this.indexManager.getStore() + "]"));
            }
            DefaultLuceneSearchEngineIndexManager.this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

                @Override
                public Object doInTransaction() throws CompassException {
                    String[] subIndexes;
                    for (final String subIndex : subIndexes = DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.polyCalcSubIndexes(ReplaceIndexOperationCallback.this.getSubIndexes(), ReplaceIndexOperationCallback.this.getAliases(), ReplaceIndexOperationCallback.this.getTypes())) {
                        DefaultLuceneSearchEngineIndexManager.this.indexHoldersCache.doUnderCacheLock(subIndex, new Runnable(){

                            public void run() {
                                DefaultLuceneSearchEngineIndexManager.this.clearCache(subIndex);
                                ReplaceIndexOperationCallback.this.indexManager.clearCache(subIndex);
                                DefaultLuceneSearchEngineIndexManager.this.searchEngineStore.copyFrom(subIndex, ReplaceIndexOperationCallback.this.indexManager.getStore());
                                DefaultLuceneSearchEngineIndexManager.this.refreshCache(subIndex);
                            }
                        });
                    }
                    return null;
                }
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Replace Index] Index [" + DefaultLuceneSearchEngineIndexManager.this.searchEngineStore + "] replaced from [" + this.indexManager.getStore() + "]"));
            }
        }

        public String[] getSubIndexes() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getSubIndexes();
            }
            return null;
        }

        public String[] getAliases() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getAliases();
            }
            return null;
        }

        public Class[] getTypes() {
            if (this.callback instanceof SearchEngineIndexManager.IndexOperationPlan) {
                return ((SearchEngineIndexManager.IndexOperationPlan)((Object)this.callback)).getTypes();
            }
            return null;
        }
    }
}

