/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;

public class RAMDirectoryStore
extends AbstractDirectoryStore {
    public static final String PROTOCOL = "ram://";
    private final Map<String, Map<String, RAMDirectory>> dirs = new ConcurrentHashMap<String, Map<String, RAMDirectory>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        RAMDirectory dir;
        Map<String, RAMDirectory> subContextDirs = this.dirs.get(subContext);
        if (subContextDirs == null) {
            Map<String, Map<String, RAMDirectory>> map = this.dirs;
            synchronized (map) {
                subContextDirs = this.dirs.get(subContext);
                if (subContextDirs == null) {
                    subContextDirs = new ConcurrentHashMap<String, RAMDirectory>();
                }
            }
        }
        if ((dir = subContextDirs.get(subIndex)) == null) {
            Map<String, RAMDirectory> map = subContextDirs;
            synchronized (map) {
                dir = subContextDirs.get(subIndex);
                if (dir == null) {
                    dir = new RAMDirectory();
                }
            }
        }
        return dir;
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.deleteIndex(dir, subContext, subIndex);
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        Map<String, RAMDirectory> subContextDirs = this.dirs.get(subContext);
        if (subContextDirs != null) {
            subContextDirs.remove(subIndex);
        }
    }

    public String[] listSubIndexes(String subContext) throws SearchEngineException, UnsupportedOperationException {
        Map<String, RAMDirectory> subContextDirs = this.dirs.get(subContext);
        if (subContextDirs == null) {
            return null;
        }
        return subContextDirs.keySet().toArray(new String[0]);
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            String[] files;
            for (String file : files = dir.list()) {
                dir.deleteFile(file);
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Faield to delete ram directory before copy", e);
        }
        return new CopyFromHolder();
    }
}

