/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.support.job;

import org.apache.lucene.index.IndexWriter;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.support.WriterHelper;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.spi.ResourceKey;

public class DeleteTransactionJob
implements TransactionJob {
    private final ResourceKey resourceKey;
    private final String resourceUID;

    public DeleteTransactionJob(ResourceKey resourceKey) {
        this.resourceKey = resourceKey;
        this.resourceUID = resourceKey.buildUID();
    }

    public String getSubIndex() {
        return this.resourceKey.getSubIndex();
    }

    public String getResourceUID() {
        return this.resourceUID;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void execute(IndexWriter writer, LuceneSearchEngineFactory sessionFactory) throws Exception {
        WriterHelper.processDelete(writer, this.resourceKey);
    }

    public String toString() {
        return "Job Delete [" + this.resourceKey + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteTransactionJob that = (DeleteTransactionJob)o;
        if (this.resourceKey != null ? !this.resourceKey.equals(that.resourceKey) : that.resourceKey != null) {
            return false;
        }
        return !(this.resourceUID != null ? !this.resourceUID.equals(that.resourceUID) : that.resourceUID != null);
    }

    public int hashCode() {
        return 31 * this.resourceUID.hashCode();
    }
}

